/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.blob;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.axiom.blob.AbstractWritableBlob;
import org.apache.axiom.blob.State;
import org.apache.axiom.blob.TempFileBlobFactory;
import org.apache.axiom.blob.TempFileInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class TempFileBlobImpl
extends AbstractWritableBlob {
    private static final Log log = LogFactory.getLog(TempFileBlobImpl.class);
    private final TempFileBlobFactory factory;
    private final Throwable trace;
    private File file;
    private State state = State.NEW;

    TempFileBlobImpl(TempFileBlobFactory factory2) {
        this.factory = factory2;
        this.trace = log.isDebugEnabled() ? new Throwable() : null;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.state != State.NEW) {
            throw new IllegalStateException();
        }
        this.file = this.factory.createTempFile();
        if (log.isDebugEnabled()) {
            log.debug("Using temporary file " + this.file);
        }
        this.file.deleteOnExit();
        FileOutputStream out = new FileOutputStream(this.file){

            public void close() throws IOException {
                super.close();
                TempFileBlobImpl.this.state = State.COMMITTED;
            }
        };
        this.state = State.UNCOMMITTED;
        return out;
    }

    public InputStream getInputStream() throws IOException {
        if (this.state != State.COMMITTED) {
            throw new IllegalStateException();
        }
        return new TempFileInputStream(this.file);
    }

    public long getSize() {
        if (this.state != State.COMMITTED) {
            throw new IllegalStateException();
        }
        return this.file.length();
    }

    public void release() throws IOException {
        if (this.file != null) {
            if (log.isDebugEnabled()) {
                log.debug("Deleting temporary file " + this.file);
            }
            if (!this.file.delete()) {
                throw new IOException("Failed to delete " + this.file);
            }
            this.file = null;
            this.state = State.RELEASED;
        }
    }

    protected void finalize() throws Throwable {
        if (this.file != null) {
            log.warn("Cleaning up unreleased temporary file " + this.file);
            if (log.isDebugEnabled()) {
                log.debug("Blob was created here", this.trace);
            }
            this.file.delete();
        }
    }
}

