/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.SecureRandom;
import java.util.Random;
import org.apache.axiom.util.UUIDCache;

public final class UIDGenerator {
    private static final long startTimeXorOperand;
    private static final long threadIdXorOperand;
    private static final long seqXorOperand;
    private static final SecureRandom secureRandom;
    private static final UUIDCache[] uuidCaches;
    private static final ThreadLocal triplet;

    private UIDGenerator() {
    }

    private static void writeReverseLongHex(long value2, StringBuilder buffer) {
        for (int i = 0; i < 16; ++i) {
            int n = (int)(value2 >> 4 * i) & 0xF;
            UIDGenerator.writeNibble(n, buffer);
        }
    }

    private static void writeNibble(int n, StringBuilder buffer) {
        buffer.append((char)(n < 10 ? 48 + n : 97 + n - 10));
    }

    private static void generateHex(StringBuilder buffer) {
        long[] values2 = (long[])triplet.get();
        long l = values2[2];
        values2[2] = l + 1L;
        UIDGenerator.writeReverseLongHex(l ^ seqXorOperand, buffer);
        UIDGenerator.writeReverseLongHex(values2[1], buffer);
        UIDGenerator.writeReverseLongHex(values2[0], buffer);
    }

    public static String generateContentId() {
        StringBuilder buffer = new StringBuilder();
        UIDGenerator.generateHex(buffer);
        buffer.append("@apache.org");
        return buffer.toString();
    }

    public static String generateMimeBoundary() {
        StringBuilder buffer = new StringBuilder("MIMEBoundary_");
        UIDGenerator.generateHex(buffer);
        return buffer.toString();
    }

    public static String generateUID() {
        StringBuilder buffer = new StringBuilder(48);
        UIDGenerator.generateHex(buffer);
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateURNString() {
        UUIDCache cache;
        StringBuilder urn = new StringBuilder(45);
        urn.append("urn:uuid:");
        UUIDCache uUIDCache = cache = uuidCaches[(int)Thread.currentThread().getId() & 0xF];
        synchronized (uUIDCache) {
            boolean fill;
            int position = cache.position;
            byte[] randomBytes = cache.randomBytes;
            if (randomBytes == null) {
                cache.randomBytes = randomBytes = new byte[4096];
                fill = true;
            } else if (position == 4096) {
                position = 0;
                fill = true;
            } else {
                fill = false;
            }
            if (fill) {
                secureRandom.nextBytes(cache.randomBytes);
            }
            UIDGenerator.writeHex(randomBytes[position], urn);
            UIDGenerator.writeHex(randomBytes[position + 1], urn);
            UIDGenerator.writeHex(randomBytes[position + 2], urn);
            UIDGenerator.writeHex(randomBytes[position + 3], urn);
            urn.append('-');
            UIDGenerator.writeHex(randomBytes[position + 4], urn);
            UIDGenerator.writeHex(randomBytes[position + 5], urn);
            urn.append('-');
            UIDGenerator.writeHex((byte)(randomBytes[position + 6] & 0xF | 0x40), urn);
            UIDGenerator.writeHex(randomBytes[position + 7], urn);
            urn.append('-');
            UIDGenerator.writeHex((byte)(randomBytes[position + 8] & 0x3F | 0x80), urn);
            UIDGenerator.writeHex(randomBytes[position + 9], urn);
            urn.append('-');
            UIDGenerator.writeHex(randomBytes[position + 10], urn);
            UIDGenerator.writeHex(randomBytes[position + 11], urn);
            UIDGenerator.writeHex(randomBytes[position + 12], urn);
            UIDGenerator.writeHex(randomBytes[position + 13], urn);
            UIDGenerator.writeHex(randomBytes[position + 14], urn);
            UIDGenerator.writeHex(randomBytes[position + 15], urn);
            cache.position = position + 16;
        }
        return urn.toString();
    }

    private static void writeHex(byte b, StringBuilder buffer) {
        UIDGenerator.writeNibble(b >> 4 & 0xF, buffer);
        UIDGenerator.writeNibble(b & 0xF, buffer);
    }

    public static URI generateURN() {
        try {
            return new URI(UIDGenerator.generateURNString());
        }
        catch (URISyntaxException ex) {
            throw new Error(ex);
        }
    }

    static {
        secureRandom = new SecureRandom();
        Random rand = new Random();
        threadIdXorOperand = rand.nextLong();
        startTimeXorOperand = rand.nextLong();
        seqXorOperand = rand.nextLong();
        uuidCaches = new UUIDCache[16];
        for (int i = 0; i < 16; ++i) {
            UIDGenerator.uuidCaches[i] = new UUIDCache();
        }
        triplet = new ThreadLocal(){

            protected Object initialValue() {
                long[] values2 = new long[3];
                values2[0] = Thread.currentThread().getId() ^ threadIdXorOperand;
                values2[1] = System.currentTimeMillis() ^ startTimeXorOperand;
                return values2;
            }
        };
    }
}

