/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.util.stax.dialect;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class JBossFactoryUnwrapper {
    private static final Log log = LogFactory.getLog(JBossFactoryUnwrapper.class);
    private final Class wrapperClass;
    private final Field actual;

    private JBossFactoryUnwrapper(Class factoryType) throws Exception {
        this.wrapperClass = Class.forName("__redirected.__" + factoryType.getSimpleName());
        try {
            this.actual = this.wrapperClass.getDeclaredField("actual");
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    JBossFactoryUnwrapper.this.actual.setAccessible(true);
                    return null;
                }
            });
        }
        catch (Exception ex) {
            log.error("Found JBoss wrapper class for " + factoryType.getSimpleName() + ", but unwrapping is not supported", ex);
            throw ex;
        }
    }

    static JBossFactoryUnwrapper create(Class factoryType) {
        try {
            return new JBossFactoryUnwrapper(factoryType);
        }
        catch (Exception ex) {
            return null;
        }
    }

    Object unwrap(Object factory2) {
        if (this.wrapperClass.isInstance(factory2)) {
            try {
                return this.actual.get(factory2);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalAccessError(ex.getMessage());
            }
        }
        return factory2;
    }
}

