/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm;

import java.util.Map;
import org.ballerinalang.jvm.types.BField;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.types.BRecordType;
import org.ballerinalang.jvm.util.Flags;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.ValueCreator;

public class BallerinaValues {
    public static MapValue<String, Object> createRecordValue(BPackage packageId, String recordTypeName) {
        ValueCreator valueCreator = ValueCreator.getValueCreator(packageId.toString());
        return valueCreator.createRecordValue(recordTypeName);
    }

    public static MapValue<String, Object> createRecordValue(BPackage packageId, String recordTypeName, Map<String, Object> valueMap) {
        MapValue<String, Object> record = BallerinaValues.createRecordValue(packageId, recordTypeName);
        for (Map.Entry<String, Object> fieldEntry : valueMap.entrySet()) {
            record.put(fieldEntry.getKey(), fieldEntry.getValue());
        }
        return record;
    }

    public static ObjectValue createObjectValue(BPackage packageId, String objectTypeName, Object ... fieldValues) {
        ValueCreator valueCreator = ValueCreator.getValueCreator(packageId.toString());
        Object[] fields = new Object[fieldValues.length * 2];
        int j = 0;
        for (int i = 0; i < fieldValues.length; ++i) {
            fields[j++] = fieldValues[i];
            fields[j++] = true;
        }
        return valueCreator.createObjectValue(objectTypeName, null, null, null, fields);
    }

    public static MapValue<String, Object> createRecord(MapValue<String, Object> record, Object ... values2) {
        BRecordType recordType = (BRecordType)record.getType();
        MapValueImpl<String, Object> mapValue = new MapValueImpl<String, Object>(recordType);
        int i = 0;
        for (Map.Entry<String, BField> fieldEntry : recordType.getFields().entrySet()) {
            Object value2 = values2[i++];
            if (Flags.isFlagOn(fieldEntry.getValue().flags, 8192) && value2 == null) continue;
            mapValue.put(fieldEntry.getKey(), value2);
        }
        return mapValue;
    }
}

