/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.Map;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.DecimalValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.StreamingJsonValue;

public class JSONGenerator
implements Closeable {
    private static final int DEFAULT_DEPTH = 10;
    private Writer writer;
    private boolean[] levelInit = new boolean[10];
    private int currentLevel;
    private boolean fieldActive;
    private static boolean[] escChars = new boolean[93];

    public JSONGenerator(OutputStream out) {
        this(out, Charset.defaultCharset());
    }

    public JSONGenerator(OutputStream out, Charset charset) {
        this(new BufferedWriter(new OutputStreamWriter(out, charset)));
    }

    public JSONGenerator(Writer writer) {
        this.writer = writer;
    }

    private void setLevelInit(int index, boolean init) {
        this.checkAndResizeLevels(index);
        this.levelInit[index] = init;
    }

    private boolean getLevelInit(int index) {
        this.checkAndResizeLevels(index);
        return this.levelInit[index];
    }

    private void checkAndResizeLevels(int index) {
        if (index >= this.levelInit.length) {
            boolean[] oldLI = this.levelInit;
            this.levelInit = new boolean[(int)Math.ceil((double)oldLI.length * 1.5)];
            System.arraycopy(oldLI, 0, this.levelInit, 0, oldLI.length);
        }
    }

    private void processStartLevel() throws IOException {
        if (!this.fieldActive) {
            if (this.getLevelInit(this.currentLevel)) {
                this.writer.write(", ");
            } else {
                this.setLevelInit(this.currentLevel, true);
            }
        } else {
            this.fieldActive = false;
        }
        ++this.currentLevel;
    }

    private void processEndLevel() {
        this.setLevelInit(this.currentLevel - 1, true);
        this.setLevelInit(this.currentLevel, false);
        --this.currentLevel;
    }

    private void processFieldInit() throws IOException {
        if (this.getLevelInit(this.currentLevel)) {
            this.writer.write(", ");
        } else {
            this.setLevelInit(this.currentLevel, true);
        }
        this.fieldActive = true;
    }

    private void processValueInit() throws IOException {
        if (this.fieldActive) {
            this.fieldActive = false;
            return;
        }
        if (this.getLevelInit(this.currentLevel)) {
            this.writer.write(", ");
        } else {
            this.setLevelInit(this.currentLevel, true);
        }
    }

    public void startObject() throws IOException {
        this.processStartLevel();
        this.writer.write(123);
    }

    public void endObject() throws IOException {
        this.writer.write(125);
        this.processEndLevel();
    }

    public void writeFieldName(String fieldName) throws IOException {
        this.processFieldInit();
        this.writeStringValue(fieldName);
        this.writer.write(":");
    }

    private void writeStringValue(String value2) throws IOException {
        this.writer.write("\"");
        int count = value2.length();
        boolean escaped = false;
        char[] chs = value2.toCharArray();
        for (int i = 0; i < count; ++i) {
            char ch = chs[i];
            if (ch >= escChars.length || !escChars[ch]) continue;
            escaped = true;
            break;
        }
        if (escaped) {
            this.writeStringEsc(chs);
        } else {
            this.writer.write(chs);
        }
        this.writer.write("\"");
    }

    public void writeString(String value2) throws IOException {
        this.processValueInit();
        this.writeStringValue(value2);
    }

    public void writeStringEsc(char[] chs) throws IOException {
        int count = chs.length;
        int index = 0;
        block10: for (int i = 0; i < count; ++i) {
            char ch = chs[i];
            switch (ch) {
                case '\"': {
                    this.writer.write(chs, index, i - index);
                    this.writer.write("\\\"");
                    index = i + 1;
                    continue block10;
                }
                case '\\': {
                    this.writer.write(chs, index, i - index);
                    this.writer.write("\\\\");
                    index = i + 1;
                    continue block10;
                }
                case '/': {
                    this.writer.write(chs, index, i - index);
                    this.writer.write("\\/");
                    index = i + 1;
                    continue block10;
                }
                case '\b': {
                    this.writer.write(chs, index, i - index);
                    this.writer.write("\\b");
                    index = i + 1;
                    continue block10;
                }
                case '\n': {
                    this.writer.write(chs, index, i - index);
                    this.writer.write("\\n");
                    index = i + 1;
                    continue block10;
                }
                case '\r': {
                    this.writer.write(chs, index, i - index);
                    this.writer.write("\\r");
                    index = i + 1;
                    continue block10;
                }
                case '\f': {
                    this.writer.write(chs, index, i - index);
                    this.writer.write("\\f");
                    index = i + 1;
                    continue block10;
                }
                case '\t': {
                    this.writer.write(chs, index, i - index);
                    this.writer.write("\\t");
                    index = i + 1;
                    continue block10;
                }
            }
        }
        if (count - index > 0) {
            this.writer.write(chs, index, count - index);
        }
    }

    public void writeNumber(long value2) throws IOException {
        this.processValueInit();
        this.writer.write(Long.toString(value2));
    }

    public void writeNumber(double value2) throws IOException {
        this.processValueInit();
        this.writer.write(Double.toString(value2));
    }

    public void writeNumber(BigDecimal value2) throws IOException {
        this.processValueInit();
        this.writer.write(value2.toString());
    }

    public void writeBoolean(boolean value2) throws IOException {
        this.processValueInit();
        this.writer.write(Boolean.toString(value2));
    }

    public void writeNull() throws IOException {
        this.processValueInit();
        this.writer.write("null");
    }

    public void writeStartArray() throws IOException {
        this.processStartLevel();
        this.writer.write("[");
    }

    public void writeEndArray() throws IOException {
        this.writer.write("]");
        this.processEndLevel();
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    public void serialize(Object json) throws IOException {
        if (json == null) {
            this.writeNull();
            return;
        }
        switch (TypeChecker.getType(json).getTag()) {
            case 20: {
                if (json instanceof StreamingJsonValue) {
                    ((StreamingJsonValue)json).serialize(this);
                    break;
                }
                this.writeStartArray();
                ArrayValue jsonArray = (ArrayValue)json;
                for (int i = 0; i < jsonArray.size(); ++i) {
                    this.serialize(jsonArray.get(i));
                }
                this.writeEndArray();
                break;
            }
            case 6: {
                this.writeBoolean((Boolean)json);
                break;
            }
            case 3: {
                this.writeNumber(((Number)json).doubleValue());
                break;
            }
            case 4: {
                this.writeNumber(((DecimalValue)json).value());
                break;
            }
            case 1: {
                this.writeNumber(((Number)json).longValue());
                break;
            }
            case 2: {
                this.writeNumber(((Number)json).intValue());
                break;
            }
            case 7: 
            case 15: {
                this.startObject();
                for (Map.Entry entry : ((MapValueImpl)json).entrySet()) {
                    this.writeFieldName((String)entry.getKey());
                    this.serialize(entry.getValue());
                }
                this.endObject();
                break;
            }
            case 5: {
                this.writeString(json.toString());
                break;
            }
        }
    }

    static {
        JSONGenerator.escChars[34] = true;
        JSONGenerator.escChars[92] = true;
        JSONGenerator.escChars[8] = true;
        JSONGenerator.escChars[10] = true;
        JSONGenerator.escChars[13] = true;
        JSONGenerator.escChars[9] = true;
    }
}

