/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.TableJSONDataSource;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BField;
import org.ballerinalang.jvm.types.BJSONType;
import org.ballerinalang.jvm.types.BMapType;
import org.ballerinalang.jvm.types.BStructureType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.types.BUnionType;
import org.ballerinalang.jvm.util.exceptions.BLangExceptionHelper;
import org.ballerinalang.jvm.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.util.exceptions.RuntimeErrors;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ArrayValueImpl;
import org.ballerinalang.jvm.values.DecimalValue;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.RefValue;
import org.ballerinalang.jvm.values.StreamingJsonValue;
import org.ballerinalang.jvm.values.TableValue;

public class JSONUtils {
    public static final String OBJECT = "object";
    public static final String ARRAY = "array";

    public static boolean hasElement(Object json, String elementName) {
        if (!JSONUtils.isJSONObject(json)) {
            return false;
        }
        return ((MapValueImpl)json).containsKey(elementName);
    }

    public static ArrayValue convertArrayToJSON(ArrayValue bArray) {
        if (bArray == null) {
            return null;
        }
        BType elementType = bArray.getElementType();
        if (elementType == BTypes.typeInt) {
            return JSONUtils.convertIntArrayToJSON(bArray);
        }
        if (elementType == BTypes.typeBoolean) {
            return JSONUtils.convertBooleanArrayToJSON(bArray);
        }
        if (elementType == BTypes.typeFloat) {
            return JSONUtils.convertFloatArrayToJSON(bArray);
        }
        if (elementType == BTypes.typeString) {
            return JSONUtils.convertStringArrayToJSON(bArray);
        }
        return JSONUtils.convertRefArrayToJSON(bArray);
    }

    public static Object convertMapToJSON(MapValueImpl<String, ?> map2, BJSONType targetType) {
        if (map2 == null) {
            return null;
        }
        MapValueImpl<String, Object> json = new MapValueImpl<String, Object>(targetType);
        for (Map.Entry structField : map2.entrySet()) {
            String key = (String)structField.getKey();
            Object value2 = structField.getValue();
            JSONUtils.populateJSON(json, key, value2, BTypes.typeJSON);
        }
        return json;
    }

    public static Object getElementOrNil(Object json, String elementName) {
        return JSONUtils.getMappingElement(json, elementName, true);
    }

    public static Object getElement(Object json, String elementName) {
        return JSONUtils.getMappingElement(json, elementName, false);
    }

    private static Object getMappingElement(Object json, String elementName, boolean returnNilOnMissingKey) {
        if (!JSONUtils.isJSONObject(json)) {
            return BallerinaErrors.createError(BallerinaErrorReasons.JSON_OPERATION_ERROR, "JSON value is not a mapping");
        }
        MapValueImpl jsonObject = (MapValueImpl)json;
        if (!jsonObject.containsKey(elementName)) {
            if (returnNilOnMissingKey) {
                return null;
            }
            return BallerinaErrors.createError(BallerinaErrorReasons.MAP_KEY_NOT_FOUND_ERROR, "Key '" + elementName + "' not found in JSON mapping");
        }
        try {
            return jsonObject.get(elementName);
        }
        catch (BallerinaException e) {
            if (e.getDetail() != null) {
                throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.JSON_GET_ERROR, e.getDetail());
            }
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.JSON_GET_ERROR, e.getMessage());
        }
        catch (Throwable t) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.JSON_GET_ERROR, t.getMessage());
        }
    }

    public static void setElement(Object json, String elementName, Object element) {
        if (!JSONUtils.isJSONObject(json)) {
            return;
        }
        try {
            ((MapValueImpl)json).put(elementName, element);
        }
        catch (ErrorValue e) {
            throw e;
        }
        catch (Throwable t) {
            throw BLangExceptionHelper.getRuntimeException(BallerinaErrorReasons.getModulePrefixedReason("lang.map", "InherentTypeViolation"), RuntimeErrors.JSON_SET_ERROR, t.getMessage());
        }
    }

    public static boolean isJSONArray(Object json) {
        if (!(json instanceof RefValue)) {
            return false;
        }
        return ((RefValue)json).getType().getTag() == 20;
    }

    public static boolean isJSONObject(Object json) {
        if (!(json instanceof RefValue)) {
            return false;
        }
        BType type = ((RefValue)json).getType();
        return type.getTag() == 7 || type.getTag() == 15;
    }

    public static void setArrayElement(Object json, long index, Object element) {
        if (!JSONUtils.isJSONArray(json)) {
            return;
        }
        BArrayType jsonArray = (BArrayType)((RefValue)json).getType();
        BType elementType = jsonArray.getElementType();
        if (!TypeChecker.checkIsType(element, elementType)) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE, elementType, element != null ? TypeChecker.getType(element) : BTypes.typeNull);
        }
        try {
            ((ArrayValue)json).add(index, element);
        }
        catch (ErrorValue e) {
            Object errorDetails = e.getDetails();
            if (errorDetails != null) {
                if (TypeChecker.getType(errorDetails).getTag() == 15 && ((MapValue)errorDetails).containsKey("message")) {
                    throw BLangExceptionHelper.getRuntimeException(e.getMessage(), RuntimeErrors.JSON_SET_ERROR, ((MapValue)errorDetails).get("message"));
                }
                throw BLangExceptionHelper.getRuntimeException(e.getMessage(), RuntimeErrors.JSON_SET_ERROR, e.getDetails());
            }
            throw BLangExceptionHelper.getRuntimeException(e.getMessage(), RuntimeErrors.JSON_SET_ERROR, e.getMessage());
        }
        catch (BallerinaException e) {
            throw BLangExceptionHelper.getRuntimeException(e.getMessage(), RuntimeErrors.JSON_SET_ERROR, e.getDetail());
        }
        catch (Throwable t) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.JSON_SET_ERROR, t.getMessage());
        }
    }

    public static MapValueImpl<String, ?> jsonToMap(Object json, BMapType mapType) {
        if (json == null || !JSONUtils.isJSONObject(json)) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE, JSONUtils.getComplexObjectTypeName(OBJECT), JSONUtils.getTypeName(json));
        }
        MapValueImpl map2 = new MapValueImpl(mapType);
        BType mapConstraint = mapType.getConstrainedType();
        if (mapConstraint == null || mapConstraint.getTag() == 17 || mapConstraint.getTag() == 7) {
            ((MapValueImpl)json).entrySet().forEach(entry -> map2.put(entry.getKey(), entry.getValue()));
            return map2;
        }
        ((MapValueImpl)json).entrySet().forEach(entry -> map2.put(entry.getKey(), JSONUtils.convertJSON(entry.getValue(), mapConstraint)));
        return map2;
    }

    public static MapValueImpl<String, Object> convertJSONToRecord(Object json, BStructureType structType) {
        if (json == null || !JSONUtils.isJSONObject(json)) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE, JSONUtils.getComplexObjectTypeName(OBJECT), JSONUtils.getTypeName(json));
        }
        MapValueImpl<String, Object> bStruct = new MapValueImpl<String, Object>(structType);
        MapValueImpl jsonObject = (MapValueImpl)json;
        for (Map.Entry<String, BField> field : structType.getFields().entrySet()) {
            BType fieldType = field.getValue().type;
            String fieldName = field.getValue().name;
            try {
                if (!jsonObject.containsKey(fieldName)) {
                    bStruct.put(fieldName, fieldType.getZeroValue());
                    continue;
                }
                Object jsonValue = jsonObject.get(fieldName);
                bStruct.put(fieldName, JSONUtils.convertJSON(jsonValue, fieldType));
            }
            catch (Exception e) {
                JSONUtils.handleError(e, fieldName);
            }
        }
        return bStruct;
    }

    public static Object convertJSON(Object jsonValue, BType targetType) {
        switch (targetType.getTag()) {
            case 1: {
                return JSONUtils.jsonNodeToInt(jsonValue);
            }
            case 3: {
                return JSONUtils.jsonNodeToFloat(jsonValue);
            }
            case 4: {
                return JSONUtils.jsonNodeToDecimal(jsonValue);
            }
            case 5: {
                return jsonValue.toString();
            }
            case 6: {
                return JSONUtils.jsonNodeToBoolean(jsonValue);
            }
            case 7: {
                if (jsonValue != null && !TypeChecker.checkIsType(jsonValue, targetType)) {
                    throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE, targetType, JSONUtils.getTypeName(jsonValue));
                }
            }
            case 17: {
                return jsonValue;
            }
            case 21: {
                BUnionType type = (BUnionType)targetType;
                if (jsonValue == null && type.isNullable()) {
                    return null;
                }
                List matchingTypes = type.getMemberTypes().stream().filter(memberType -> memberType != BTypes.typeNull).collect(Collectors.toList());
                if (matchingTypes.size() != 1) break;
                return JSONUtils.convertJSON(jsonValue, (BType)matchingTypes.get(0));
            }
            case 12: 
            case 34: {
                return JSONUtils.convertJSONToRecord(jsonValue, (BStructureType)targetType);
            }
            case 20: {
                return JSONUtils.convertJSONToBArray(jsonValue, (BArrayType)targetType);
            }
            case 15: {
                return JSONUtils.jsonToMap(jsonValue, (BMapType)targetType);
            }
            case 10: {
                if (jsonValue == null) {
                    return null;
                }
            }
            default: {
                throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE, targetType, JSONUtils.getTypeName(jsonValue));
            }
        }
        throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE, targetType, JSONUtils.getTypeName(jsonValue));
    }

    public static ArrayValue getKeys(Object json) {
        if (json == null || !JSONUtils.isJSONObject(json)) {
            return new ArrayValueImpl(new BArrayType(BTypes.typeString));
        }
        String[] keys2 = (String[])((MapValueImpl)json).getKeys();
        return new ArrayValueImpl(keys2);
    }

    public static Object convertUnionTypeToJSON(Object source2, BJSONType targetType) {
        if (source2 == null) {
            return null;
        }
        BType type = TypeChecker.getType(source2);
        switch (type.getTag()) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return source2;
            }
            case 10: {
                return null;
            }
            case 12: 
            case 15: 
            case 34: {
                return JSONUtils.convertMapToJSON((MapValueImpl)source2, targetType);
            }
            case 7: {
                return source2;
            }
        }
        throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE, BTypes.typeJSON, type);
    }

    public static void remove(Object json, String fieldName) {
        if (!JSONUtils.isJSONObject(json)) {
            return;
        }
        ((MapValueImpl)json).remove(fieldName);
    }

    public static ErrorValue getErrorIfUnmergeable(Object j1, Object j2, List<ObjectPair> visitedPairs) {
        if (j1 == null || j2 == null) {
            return null;
        }
        BType j1Type = TypeChecker.getType(j1);
        BType j2Type = TypeChecker.getType(j2);
        if (j1Type.getTag() != 15 || j2Type.getTag() != 15) {
            return BallerinaErrors.createError(BallerinaErrorReasons.MERGE_JSON_ERROR, "Cannot merge JSON values of types '" + j1Type + "' and '" + j2Type + "'");
        }
        ObjectPair currentPair = new ObjectPair(j1, j2);
        if (visitedPairs.contains(currentPair)) {
            return BallerinaErrors.createError(BallerinaErrorReasons.MERGE_JSON_ERROR, "Cannot merge JSON values with cyclic references");
        }
        visitedPairs.add(currentPair);
        MapValue m1 = (MapValue)j1;
        MapValue m2 = (MapValue)j2;
        for (Map.Entry entry : m2.entrySet()) {
            ErrorValue elementMergeNullableError;
            String key = (String)entry.getKey();
            if (!m1.containsKey(key) || (elementMergeNullableError = JSONUtils.getErrorIfUnmergeable(m1.get(key), entry.getValue(), visitedPairs)) == null) continue;
            MapValueImpl<String, Object> detailMap = new MapValueImpl<String, Object>(BTypes.typeErrorDetail);
            detailMap.put("message", "JSON Merge failed for key '" + key + "'");
            detailMap.put("cause", elementMergeNullableError);
            return BallerinaErrors.createError(BallerinaErrorReasons.MERGE_JSON_ERROR, detailMap);
        }
        return null;
    }

    public static Object mergeJson(Object j1, Object j2, boolean checkMergeability) {
        if (j1 == null) {
            return j2;
        }
        if (j2 == null) {
            return j1;
        }
        if (checkMergeability) {
            BType j1Type = TypeChecker.getType(j1);
            BType j2Type = TypeChecker.getType(j2);
            if (j1Type.getTag() != 15 || j2Type.getTag() != 15) {
                return BallerinaErrors.createError(BallerinaErrorReasons.MERGE_JSON_ERROR, "Cannot merge JSON values of types '" + j1Type + "' and '" + j2Type + "'");
            }
        }
        MapValue m1 = (MapValue)j1;
        MapValue m2 = (MapValue)j2;
        return m1.merge(m2, true);
    }

    public static ArrayValue convertJSONToBArray(Object json, BArrayType targetArrayType) {
        if (!(json instanceof ArrayValue)) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE, JSONUtils.getComplexObjectTypeName(ARRAY), JSONUtils.getTypeName(json));
        }
        BType targetElementType = targetArrayType.getElementType();
        ArrayValue jsonArray = (ArrayValue)json;
        switch (targetElementType.getTag()) {
            case 1: {
                return JSONUtils.jsonArrayToBIntArray(jsonArray);
            }
            case 3: {
                return JSONUtils.jsonArrayToBFloatArray(jsonArray);
            }
            case 4: {
                return JSONUtils.jsonArrayToBDecimalArray(jsonArray);
            }
            case 5: {
                return JSONUtils.jsonArrayToBStringArray(jsonArray);
            }
            case 6: {
                return JSONUtils.jsonArrayToBooleanArray(jsonArray);
            }
            case 17: {
                ArrayValueImpl array2 = new ArrayValueImpl(targetArrayType);
                for (int i = 0; i < jsonArray.size(); ++i) {
                    array2.add((long)i, jsonArray.getRefValue(i));
                }
                return array2;
            }
        }
        ArrayValueImpl array3 = new ArrayValueImpl(targetArrayType);
        for (int i = 0; i < jsonArray.size(); ++i) {
            array3.append(JSONUtils.convertJSON(jsonArray.getRefValue(i), targetElementType));
        }
        return array3;
    }

    public static Object toJSON(TableValue table2) {
        TableJSONDataSource jsonDataSource = new TableJSONDataSource(table2);
        if (table2.isInMemoryTable()) {
            return jsonDataSource.build();
        }
        return new StreamingJsonValue(jsonDataSource);
    }

    public static ErrorValue createJsonConversionError(Throwable throwable, String prefix) {
        String detail = throwable.getMessage() != null ? prefix + ": " + throwable.getMessage() : "error occurred in JSON Conversion";
        return BallerinaErrors.createError(BallerinaErrorReasons.JSON_CONVERSION_ERROR, detail);
    }

    private static long jsonNodeToInt(Object json) {
        if (!(json instanceof Long)) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE_FOR_CASTING_JSON, BTypes.typeInt, JSONUtils.getTypeName(json));
        }
        return (Long)json;
    }

    private static double jsonNodeToFloat(Object json) {
        if (json instanceof Integer) {
            return ((Integer)json).longValue();
        }
        if (json instanceof Double) {
            return (Double)json;
        }
        throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE_FOR_CASTING_JSON, BTypes.typeFloat, JSONUtils.getTypeName(json));
    }

    private static DecimalValue jsonNodeToDecimal(Object json) {
        BigDecimal decimal2 = null;
        if (json instanceof Integer) {
            decimal2 = new BigDecimal(((Integer)json).longValue());
        } else if (json instanceof Double) {
            decimal2 = new BigDecimal((Double)json);
        } else if (json instanceof BigDecimal) {
            decimal2 = (BigDecimal)json;
        } else {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE_FOR_CASTING_JSON, BTypes.typeDecimal, JSONUtils.getTypeName(json));
        }
        return new DecimalValue(decimal2);
    }

    private static boolean jsonNodeToBoolean(Object json) {
        if (!(json instanceof Boolean)) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE_FOR_CASTING_JSON, BTypes.typeBoolean, JSONUtils.getTypeName(json));
        }
        return (Boolean)json;
    }

    private static ArrayValue jsonArrayToBIntArray(ArrayValue arrayNode) {
        ArrayValueImpl intArray = new ArrayValueImpl(new BArrayType(BTypes.typeInt));
        for (int i = 0; i < arrayNode.size(); ++i) {
            Object jsonValue = arrayNode.getRefValue(i);
            intArray.add((long)i, JSONUtils.jsonNodeToInt(jsonValue));
        }
        return intArray;
    }

    private static ArrayValue jsonArrayToBFloatArray(ArrayValue arrayNode) {
        ArrayValueImpl floatArray = new ArrayValueImpl(new BArrayType(BTypes.typeFloat));
        for (int i = 0; i < arrayNode.size(); ++i) {
            Object jsonValue = arrayNode.getRefValue(i);
            floatArray.add((long)i, JSONUtils.jsonNodeToFloat(jsonValue));
        }
        return floatArray;
    }

    private static ArrayValue jsonArrayToBDecimalArray(ArrayValue arrayNode) {
        ArrayValueImpl decimalArray = new ArrayValueImpl(new BArrayType(BTypes.typeDecimal));
        for (int i = 0; i < arrayNode.size(); ++i) {
            Object jsonValue = arrayNode.getRefValue(i);
            decimalArray.add((long)i, JSONUtils.jsonNodeToDecimal(jsonValue));
        }
        return decimalArray;
    }

    private static ArrayValue jsonArrayToBStringArray(ArrayValue arrayNode) {
        ArrayValueImpl stringArray = new ArrayValueImpl(new BArrayType(BTypes.typeString));
        for (int i = 0; i < arrayNode.size(); ++i) {
            stringArray.add((long)i, arrayNode.getRefValue(i).toString());
        }
        return stringArray;
    }

    private static ArrayValue jsonArrayToBooleanArray(ArrayValue arrayNode) {
        ArrayValueImpl booleanArray = new ArrayValueImpl(new BArrayType(BTypes.typeBoolean));
        for (int i = 0; i < arrayNode.size(); ++i) {
            Object jsonValue = arrayNode.getRefValue(i);
            booleanArray.add((long)i, JSONUtils.jsonNodeToBoolean(jsonValue));
        }
        return booleanArray;
    }

    private static ArrayValue convertRefArrayToJSON(ArrayValue refValueArray) {
        ArrayValueImpl json = new ArrayValueImpl(new BArrayType(BTypes.typeJSON));
        block5: for (int i = 0; i < refValueArray.size(); ++i) {
            Object value2 = refValueArray.getRefValue(i);
            if (value2 == null) {
                json.append(null);
            }
            BType type = TypeChecker.getType(value2);
            switch (type.getTag()) {
                case 7: {
                    json.append(value2);
                    continue block5;
                }
                case 12: 
                case 15: 
                case 34: {
                    json.append(JSONUtils.convertMapToJSON((MapValueImpl)value2, (BJSONType)BTypes.typeJSON));
                    continue block5;
                }
                case 20: {
                    json.append(JSONUtils.convertArrayToJSON((ArrayValue)value2));
                    continue block5;
                }
                default: {
                    throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE, BTypes.typeJSON, type);
                }
            }
        }
        return json;
    }

    private static ArrayValue convertIntArrayToJSON(ArrayValue intArray) {
        ArrayValueImpl json = new ArrayValueImpl(new BArrayType(BTypes.typeJSON));
        for (int i = 0; i < intArray.size(); ++i) {
            long value2 = intArray.getInt(i);
            json.append(new Long(value2));
        }
        return json;
    }

    private static ArrayValue convertFloatArrayToJSON(ArrayValue floatArray) {
        ArrayValueImpl json = new ArrayValueImpl(new BArrayType(BTypes.typeJSON));
        for (int i = 0; i < floatArray.size(); ++i) {
            double value2 = floatArray.getFloat(i);
            json.append(new Double(value2));
        }
        return json;
    }

    private static ArrayValue convertStringArrayToJSON(ArrayValue stringArray) {
        ArrayValueImpl json = new ArrayValueImpl(new BArrayType(BTypes.typeJSON));
        for (int i = 0; i < stringArray.size(); ++i) {
            json.append(stringArray.getString(i));
        }
        return json;
    }

    private static ArrayValue convertBooleanArrayToJSON(ArrayValue booleanArray) {
        ArrayValueImpl json = new ArrayValueImpl(new BArrayType(BTypes.typeJSON));
        for (int i = 0; i < booleanArray.size(); ++i) {
            boolean value2 = booleanArray.getBoolean(i);
            json.append(value2);
        }
        return json;
    }

    private static void populateJSON(MapValueImpl<String, Object> json, String key, Object value2, BType exptType) {
        try {
            if (value2 == null) {
                json.put(key, null);
                return;
            }
            BType type = TypeChecker.getType(value2);
            switch (type.getTag()) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    json.put(key, value2);
                    break;
                }
                case 20: {
                    json.put(key, JSONUtils.convertArrayToJSON((ArrayValue)value2));
                    break;
                }
                case 12: 
                case 15: 
                case 34: {
                    json.put(key, JSONUtils.convertMapToJSON((MapValueImpl)value2, (BJSONType)exptType));
                    break;
                }
                default: {
                    throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE, BTypes.typeJSON, type);
                }
            }
        }
        catch (Exception e) {
            JSONUtils.handleError(e, key);
        }
    }

    private static String getTypeName(Object jsonValue) {
        if (jsonValue == null) {
            return BTypes.typeNull.toString();
        }
        return TypeChecker.getType(jsonValue).toString();
    }

    private static String getComplexObjectTypeName(String nodeType) {
        return "json-" + nodeType;
    }

    private static void handleError(Exception e, String fieldName) {
        String errorMsg = e.getCause() == null ? "error while mapping '" + fieldName + "': " : "";
        throw new BallerinaException(errorMsg + e.getMessage(), e);
    }

    private static class ObjectPair {
        Object lhsObject;
        Object rhsObject;

        public ObjectPair(Object lhsObject, Object rhsObject) {
            this.lhsObject = lhsObject;
            this.rhsObject = rhsObject;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ObjectPair)) {
                return false;
            }
            ObjectPair other = (ObjectPair)obj;
            return this.lhsObject == other.lhsObject && this.rhsObject == other.rhsObject;
        }
    }
}

