/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.observability;

import io.opentelemetry.api.trace.StatusCode;
import java.util.Collections;
import java.util.Map;
import org.ballerinalang.jvm.observability.ObserverContext;
import org.ballerinalang.jvm.observability.tracer.BOtelSpan;
import org.ballerinalang.jvm.values.ErrorValue;

public final class OtelTracingUtils {
    private OtelTracingUtils() {
    }

    public static void startObservation(ObserverContext observerContext, boolean isClient) {
        BOtelSpan span;
        String operationName;
        String serviceName = observerContext.getServiceName();
        String string2 = observerContext.getResourceName() != null ? observerContext.getResourceName() : (operationName = observerContext.getActionName() != null ? observerContext.getActionName() : "Unknown Service");
        if (observerContext.getParent() != null) {
            BOtelSpan parentSpan = (BOtelSpan)observerContext.getParent().getProperty("_span_");
            span = BOtelSpan.start(parentSpan, serviceName, operationName, isClient);
        } else {
            Map httpHeaders = (Map)observerContext.getProperty("trace_properties");
            span = httpHeaders != null ? BOtelSpan.start(httpHeaders, serviceName, operationName, isClient) : BOtelSpan.start(serviceName, operationName, isClient);
        }
        if (isClient) {
            observerContext.addProperty("trace_properties", span.extractContextAsHttpHeaders());
        }
        observerContext.addProperty("_span_", span);
    }

    public static void stopObservation(ObserverContext observerContext) {
        BOtelSpan span = (BOtelSpan)observerContext.getProperty("_span_");
        if (span != null) {
            ErrorValue bError = (ErrorValue)observerContext.getProperty("_ballerina_error_value_");
            if (bError != null) {
                span.addTag("error.message", bError.getPrintableStackTrace());
                span.setStatus(StatusCode.ERROR);
            } else {
                span.setStatus(StatusCode.OK);
            }
            Integer statusCode = (Integer)observerContext.getProperty("_http_status_code_");
            if (statusCode != null && statusCode >= 100) {
                span.addTags(Collections.singletonMap("http.status_code", Integer.toString(statusCode)));
            }
            Map<String, String> traceTags = observerContext.getTags();
            span.addTags(traceTags);
            span.finishSpan();
        }
    }
}

