/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.observability.metrics;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.ballerinalang.jvm.observability.metrics.Tag;

public class MetricId {
    private final String name;
    private final String description;
    private final Set<Tag> tags;
    private final int hashCode;

    public MetricId(String name, String description, List<Tag> tags) {
        this(name, description, (Set<Tag>)(tags != null ? new HashSet<Tag>(tags) : null));
    }

    public MetricId(String name, String description, Set<Tag> tags) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Name is required.");
        }
        this.name = name;
        this.tags = tags != null ? Collections.unmodifiableSet(tags) : Collections.emptySet();
        this.description = description == null ? "" : description;
        this.hashCode = Objects.hash(name, tags);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Set<Tag> getTags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricId metricId = (MetricId)o;
        return Objects.equals(this.name, metricId.name) && Objects.equals(this.tags, metricId.tags);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MetricId{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", description='").append(this.description).append('\'');
        sb.append(", tags=").append(this.tags);
        sb.append('}');
        return sb.toString();
    }
}

