/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.observability.metrics;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.ToDoubleFunction;
import org.ballerinalang.jvm.observability.metrics.DefaultMetricRegistry;
import org.ballerinalang.jvm.observability.metrics.Metric;
import org.ballerinalang.jvm.observability.metrics.MetricId;
import org.ballerinalang.jvm.observability.metrics.MetricRegistry;
import org.ballerinalang.jvm.observability.metrics.Tag;
import org.ballerinalang.jvm.observability.metrics.Tags;

public interface PolledGauge
extends Metric {
    public static <T> Builder<T> builder(String name, T obj, ToDoubleFunction<T> valueFunction) {
        return new Builder(name, obj, valueFunction);
    }

    @Override
    default public PolledGauge register() {
        return DefaultMetricRegistry.getInstance().register(this);
    }

    @Override
    default public void unregister() {
        DefaultMetricRegistry.getInstance().unregister(this);
    }

    public double getValue();

    public static class Builder<T>
    implements Metric.Builder<Builder<T>, PolledGauge> {
        private final String name;
        private final Set<Tag> tags = new HashSet<Tag>(10);
        private String description;
        private T obj;
        private ToDoubleFunction<T> valueFunction;

        private Builder(String name, T obj, ToDoubleFunction<T> valueFunction) {
            this.name = name;
            this.obj = obj;
            this.valueFunction = valueFunction;
        }

        @Override
        public Builder<T> description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder tags(String ... keyValues) {
            Tags.tags(this.tags, keyValues);
            return this;
        }

        @Override
        public Builder tags(Iterable<Tag> tags) {
            Tags.tags(this.tags, tags);
            return this;
        }

        @Override
        public Builder tag(String key, String value2) {
            Tags.tags(this.tags, key, value2);
            return this;
        }

        @Override
        public Builder tags(Map<String, String> tags) {
            Tags.tags(this.tags, tags);
            return this;
        }

        @Override
        public PolledGauge register() {
            return this.register(DefaultMetricRegistry.getInstance());
        }

        @Override
        public PolledGauge register(MetricRegistry registry) {
            return registry.polledGauge(new MetricId(this.name, this.description, this.tags), this.obj, this.valueFunction);
        }

        @Override
        public PolledGauge build() {
            return DefaultMetricRegistry.getInstance().getMetricProvider().newPolledGauge(new MetricId(this.name, this.description, this.tags), this.obj, this.valueFunction);
        }
    }
}

