/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.types;

import java.util.Arrays;
import java.util.HashMap;
import org.ballerinalang.jvm.IteratorUtils;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.types.BAnyType;
import org.ballerinalang.jvm.types.BAnydataType;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BBooleanType;
import org.ballerinalang.jvm.types.BByteType;
import org.ballerinalang.jvm.types.BDecimalType;
import org.ballerinalang.jvm.types.BErrorType;
import org.ballerinalang.jvm.types.BField;
import org.ballerinalang.jvm.types.BFiniteType;
import org.ballerinalang.jvm.types.BFloatType;
import org.ballerinalang.jvm.types.BFutureType;
import org.ballerinalang.jvm.types.BHandleType;
import org.ballerinalang.jvm.types.BIntegerType;
import org.ballerinalang.jvm.types.BIteratorType;
import org.ballerinalang.jvm.types.BJSONType;
import org.ballerinalang.jvm.types.BMapType;
import org.ballerinalang.jvm.types.BNullType;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.types.BRecordType;
import org.ballerinalang.jvm.types.BServiceType;
import org.ballerinalang.jvm.types.BStreamType;
import org.ballerinalang.jvm.types.BStringType;
import org.ballerinalang.jvm.types.BTableType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypedescType;
import org.ballerinalang.jvm.types.BUnionType;
import org.ballerinalang.jvm.types.BXMLAttributesType;
import org.ballerinalang.jvm.types.BXMLType;
import org.ballerinalang.jvm.types.TypeFlags;

public class BTypes {
    public static BType typeInt = new BIntegerType("int", new BPackage(null, null, null));
    public static BType typeIntSigned32 = new BIntegerType("Signed32", new BPackage("ballerina", "lang.int", null), 38);
    public static BType typeIntSigned16 = new BIntegerType("Signed16", new BPackage("ballerina", "lang.int", null), 39);
    public static BType typeIntSigned8 = new BIntegerType("Signed8", new BPackage("ballerina", "lang.int", null), 40);
    public static BType typeIntUnsigned32 = new BIntegerType("Unsigned32", new BPackage("ballerina", "lang.int", null), 41);
    public static BType typeIntUnsigned16 = new BIntegerType("Unsigned16", new BPackage("ballerina", "lang.int", null), 42);
    public static BType typeIntUnsigned8 = new BIntegerType("Unsigned8", new BPackage("ballerina", "lang.int", null), 43);
    public static BType typeElement = new BXMLType("Element", new BPackage("ballerina", "lang.xml", null), 45);
    public static BType typeProcessingInstruction = new BXMLType("ProcessingInstruction", new BPackage("ballerina", "lang.xml", null), 46);
    public static BType typeComment = new BXMLType("Comment", new BPackage("ballerina", "lang.xml", null), 47);
    public static BType typeText = new BXMLType("Text", new BPackage("ballerina", "lang.xml", null), 48);
    public static BType typeByte = new BByteType("byte", new BPackage(null, null, null));
    public static BType typeFloat = new BFloatType("float", new BPackage(null, null, null));
    public static BType typeDecimal = new BDecimalType("decimal", new BPackage(null, null, null));
    public static BType typeString = new BStringType("string", new BPackage(null, null, null));
    public static BType typeStringChar = new BStringType("Char", new BPackage("ballerina", "lang.string", null), 44);
    public static BType typeBoolean = new BBooleanType("boolean", new BPackage(null, null, null));
    public static BType typeXML = new BXMLType("xml", new BPackage(null, null, null));
    public static BType typeJSON = new BJSONType("json", new BPackage(null, null, null));
    public static BType typeAny = new BAnyType("any", new BPackage(null, null, null));
    public static BType typeAnydata = new BAnydataType("anydata", new BPackage(null, null, null));
    public static BType typeStream = new BStreamType("stream", typeAny, new BPackage(null, null, null));
    public static BType typeTypedesc = new BTypedescType("typedesc", new BPackage(null, null, null));
    public static BType typeMap = new BMapType("map", typeAny, new BPackage(null, null, null));
    public static BType typeTable = new BTableType("table", typeAnydata, new BPackage(null, null, null));
    public static BType typeFuture = new BFutureType("future", new BPackage(null, null, null));
    public static BType typeNull = new BNullType("()", new BPackage(null, null, null));
    public static BType typeXMLAttributes = new BXMLAttributesType("xml-attributes", new BPackage(null, null, null));
    public static BType typeIterator = new BIteratorType("iterator", new BPackage(null, null, null));
    public static BType typeAnyService = new BServiceType("service", new BPackage(null, null, null), 0);
    public static BRecordType typeErrorDetail = new BRecordType("detail", new BPackage(null, null, null), 0, false, TypeFlags.asMask(2, 4));
    public static BErrorType typeError = new BErrorType("error", new BPackage(null, null, null), typeString, typeErrorDetail);
    public static BType typePureType = new BUnionType(Arrays.asList(typeAnydata, typeError));
    public static BType typeAllType = new BUnionType(Arrays.asList(typeAny, typeError));
    public static BType typeHandle = new BHandleType("handle", new BPackage(null, null, null));
    public static BRecordType stringItrNextReturnType = IteratorUtils.createIteratorNextReturnType(typeString);
    public static BRecordType xmlItrNextReturnType = IteratorUtils.createIteratorNextReturnType(new BUnionType(Arrays.asList(typeString, typeXML)));

    private BTypes() {
    }

    public static boolean isValueType(BType type) {
        if (type == typeInt || type == typeByte || type == typeFloat || type == typeDecimal || type == typeString || type == typeBoolean) {
            return true;
        }
        if (type != null && type.getTag() == 33) {
            for (Object value2 : ((BFiniteType)type).valueSpace) {
                if (BTypes.isValueType(TypeChecker.getType(value2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static BType getTypeFromName(String typeName) {
        switch (typeName) {
            case "int": {
                return typeInt;
            }
            case "byte": {
                return typeByte;
            }
            case "float": {
                return typeFloat;
            }
            case "decimal": {
                return typeDecimal;
            }
            case "string": {
                return typeString;
            }
            case "boolean": {
                return typeBoolean;
            }
            case "json": {
                return typeJSON;
            }
            case "xml": {
                return typeXML;
            }
            case "map": {
                return typeMap;
            }
            case "future": {
                return typeFuture;
            }
            case "stream": {
                return typeStream;
            }
            case "any": {
                return typeAny;
            }
            case "typedesc": {
                return typeTypedesc;
            }
            case "()": {
                return typeNull;
            }
            case "xml-attributes": {
                return typeXMLAttributes;
            }
            case "error": {
                return typeError;
            }
            case "anydata": {
                return typeAnydata;
            }
        }
        throw new IllegalStateException("Unknown type name");
    }

    public static BType fromString(String typeName) {
        if (typeName.endsWith("[]")) {
            String elementTypeName = typeName.substring(0, typeName.length() - 2);
            BType elemType = BTypes.fromString(elementTypeName);
            return new BArrayType(elemType);
        }
        return BTypes.getTypeFromName(typeName);
    }

    static {
        HashMap<String, BField> fields = new HashMap<String, BField>();
        fields.put("message", new BField(typeString, "message", 8193));
        fields.put("cause", new BField(typeError, "cause", 8193));
        typeErrorDetail.setFields(fields);
        BType[] restFieldType = new BType[]{typeAnydata, typeError};
        BTypes.typeErrorDetail.restFieldType = new BUnionType(Arrays.asList(restFieldType));
    }
}

