/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.values;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.IntStream;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.commons.ArrayState;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.util.exceptions.BLangExceptionHelper;
import org.ballerinalang.jvm.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.util.exceptions.RuntimeErrors;
import org.ballerinalang.jvm.values.AbstractArrayValue;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.IteratorValue;
import org.ballerinalang.jvm.values.RefValue;
import org.ballerinalang.jvm.values.api.BArray;
import org.ballerinalang.jvm.values.api.BString;
import org.ballerinalang.jvm.values.freeze.FreezeUtils;
import org.ballerinalang.jvm.values.freeze.Status;
import org.ballerinalang.jvm.values.utils.StringUtils;

public class ArrayValueImpl
extends AbstractArrayValue {
    protected BArrayType arrayType;
    protected BType elementType;
    protected Object[] refValues;
    private long[] intValues;
    private boolean[] booleanValues;
    private byte[] byteValues;
    private double[] floatValues;
    private String[] stringValues;
    private BString[] bStringValues;

    @Deprecated
    public ArrayValueImpl(Object[] values2, BArrayType type) {
        this.refValues = values2;
        this.arrayType = type;
        this.size = values2.length;
        if (type.getTag() == 20) {
            this.elementType = type.getElementType();
        }
    }

    @Deprecated
    public ArrayValueImpl(long[] values2) {
        this.intValues = values2;
        this.size = values2.length;
        this.setArrayType(BTypes.typeInt);
    }

    @Deprecated
    public ArrayValueImpl(boolean[] values2) {
        this.booleanValues = values2;
        this.size = values2.length;
        this.setArrayType(BTypes.typeBoolean);
    }

    @Deprecated
    public ArrayValueImpl(byte[] values2) {
        this.byteValues = values2;
        this.size = values2.length;
        this.setArrayType(BTypes.typeByte);
    }

    @Deprecated
    public ArrayValueImpl(double[] values2) {
        this.floatValues = values2;
        this.size = values2.length;
        this.setArrayType(BTypes.typeFloat);
    }

    @Deprecated
    public ArrayValueImpl(String[] values2) {
        this.stringValues = values2;
        this.size = values2.length;
        this.setArrayType(BTypes.typeString);
    }

    @Deprecated
    public ArrayValueImpl(BString[] values2) {
        this.bStringValues = values2;
        this.size = values2.length;
        this.setArrayType(BTypes.typeString);
    }

    @Deprecated
    public ArrayValueImpl(BArrayType type) {
        this.arrayType = type;
        BArrayType arrayType = type;
        this.elementType = arrayType.getElementType();
        this.initArrayValues(this.elementType, false);
        if (arrayType.getState() == ArrayState.CLOSED_SEALED) {
            this.size = this.maxSize = arrayType.getSize();
        }
    }

    private void initArrayValues(BType elementType, boolean useBString) {
        int initialArraySize = this.arrayType.getSize() != -1 ? this.arrayType.getSize() : 100;
        switch (elementType.getTag()) {
            case 1: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                this.intValues = new long[initialArraySize];
                break;
            }
            case 3: {
                this.floatValues = new double[initialArraySize];
                break;
            }
            case 5: 
            case 44: {
                if (useBString) {
                    this.bStringValues = new BString[initialArraySize];
                    break;
                }
                this.stringValues = new String[initialArraySize];
                break;
            }
            case 6: {
                this.booleanValues = new boolean[initialArraySize];
                break;
            }
            case 2: {
                this.byteValues = new byte[initialArraySize];
                break;
            }
            default: {
                this.refValues = new Object[initialArraySize];
                if (this.arrayType.getState() != ArrayState.CLOSED_SEALED) break;
                this.fillerValueCheck(initialArraySize, initialArraySize);
                this.fillValues(initialArraySize);
            }
        }
    }

    @Deprecated
    public ArrayValueImpl(BArrayType type, long size) {
        this.arrayType = type;
        this.elementType = type.getElementType();
        this.initArrayValues(this.elementType, false);
        if (size != -1L) {
            this.size = this.maxSize = (int)size;
        }
    }

    @Deprecated
    public ArrayValueImpl(BArrayType type, long size, boolean useBString) {
        this.arrayType = type;
        this.elementType = type.getElementType();
        this.initArrayValues(this.elementType, useBString);
        if (size != -1L) {
            this.size = this.maxSize = (int)size;
        }
    }

    @Override
    public Object get(long index) {
        this.rangeCheckForGet(index, this.size);
        switch (this.elementType.getTag()) {
            case 1: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                return this.intValues[(int)index];
            }
            case 6: {
                return this.booleanValues[(int)index];
            }
            case 2: {
                return Byte.toUnsignedInt(this.byteValues[(int)index]);
            }
            case 3: {
                return this.floatValues[(int)index];
            }
            case 5: 
            case 44: {
                return this.stringValues[(int)index];
            }
        }
        return this.refValues[(int)index];
    }

    @Override
    public Object getRefValue(long index) {
        this.rangeCheckForGet(index, this.size);
        if (this.refValues != null) {
            return this.refValues[(int)index];
        }
        return this.get(index);
    }

    @Override
    public Object fillAndGetRefValue(long index) {
        if (this.refValues != null) {
            if (index >= (long)this.size) {
                this.handleFrozenArrayValue();
                this.fillRead(index, this.refValues.length);
            }
            return this.refValues[(int)index];
        }
        return this.get(index);
    }

    @Override
    public long getInt(long index) {
        this.rangeCheckForGet(index, this.size);
        if (this.intValues != null) {
            return this.intValues[(int)index];
        }
        if (this.refValues != null) {
            return (Long)this.refValues[(int)index];
        }
        return Byte.toUnsignedInt(this.byteValues[(int)index]);
    }

    @Override
    public boolean getBoolean(long index) {
        this.rangeCheckForGet(index, this.size);
        if (this.booleanValues != null) {
            return this.booleanValues[(int)index];
        }
        return (Boolean)this.refValues[(int)index];
    }

    @Override
    public byte getByte(long index) {
        this.rangeCheckForGet(index, this.size);
        if (this.byteValues != null) {
            return this.byteValues[(int)index];
        }
        return ((Integer)this.refValues[(int)index]).byteValue();
    }

    @Override
    public double getFloat(long index) {
        this.rangeCheckForGet(index, this.size);
        if (this.floatValues != null) {
            return this.floatValues[(int)index];
        }
        return (Double)this.refValues[(int)index];
    }

    @Override
    @Deprecated
    public String getString(long index) {
        this.rangeCheckForGet(index, this.size);
        if (this.stringValues != null) {
            return this.stringValues[(int)index];
        }
        if (this.bStringValues != null) {
            return this.bStringValues[(int)index].getValue();
        }
        return (String)this.refValues[(int)index];
    }

    @Override
    public BString getBString(long index) {
        this.rangeCheckForGet(index, this.size);
        if (this.bStringValues != null) {
            return this.bStringValues[(int)index];
        }
        return (BString)this.refValues[(int)index];
    }

    @Override
    public void add(long index, Object value2) {
        this.handleFrozenArrayValue();
        BType type = TypeChecker.getType(value2);
        switch (this.elementType.getTag()) {
            case 6: {
                this.prepareForAdd(index, value2, type, this.booleanValues.length);
                this.booleanValues[(int)index] = (Boolean)value2;
                return;
            }
            case 3: {
                this.prepareForAdd(index, value2, type, this.floatValues.length);
                this.floatValues[(int)index] = (Double)value2;
                return;
            }
            case 2: {
                this.prepareForAdd(index, value2, type, this.byteValues.length);
                this.byteValues[(int)index] = ((Number)value2).byteValue();
                return;
            }
            case 1: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                this.prepareForAdd(index, value2, type, this.intValues.length);
                this.intValues[(int)index] = (Long)value2;
                return;
            }
            case 5: 
            case 44: {
                this.prepareForAdd(index, value2, type, this.stringValues.length);
                this.stringValues[(int)index] = (String)value2;
                return;
            }
        }
        this.prepareForAdd(index, value2, type, this.refValues.length);
        this.refValues[(int)index] = value2;
    }

    @Override
    public void add(long index, long value2) {
        this.handleFrozenArrayValue();
        if (this.intValues != null) {
            this.prepareForAdd(index, value2, BTypes.typeInt, this.intValues.length);
            this.intValues[(int)index] = value2;
            return;
        }
        this.prepareForAdd(index, value2, TypeChecker.getType(value2), this.byteValues.length);
        this.byteValues[(int)index] = (byte)Long.valueOf(value2).intValue();
    }

    @Override
    public void add(long index, boolean value2) {
        this.handleFrozenArrayValue();
        this.prepareForAdd(index, value2, BTypes.typeBoolean, this.booleanValues.length);
        this.booleanValues[(int)index] = value2;
    }

    @Override
    public void add(long index, byte value2) {
        this.handleFrozenArrayValue();
        this.prepareForAdd(index, value2, BTypes.typeByte, this.byteValues.length);
        this.byteValues[(int)index] = value2;
    }

    @Override
    public void add(long index, double value2) {
        this.handleFrozenArrayValue();
        this.prepareForAdd(index, value2, BTypes.typeFloat, this.floatValues.length);
        this.floatValues[(int)index] = value2;
    }

    @Override
    @Deprecated
    public void add(long index, String value2) {
        this.handleFrozenArrayValue();
        this.prepareForAdd(index, value2, BTypes.typeString, this.stringValues.length);
        this.stringValues[(int)index] = value2;
    }

    @Override
    public void add(long index, BString value2) {
        this.handleFrozenArrayValue();
        this.prepareForAdd(index, value2, BTypes.typeString, this.bStringValues.length);
        this.bStringValues[(int)index] = value2;
    }

    @Override
    public void append(Object value2) {
        this.add((long)this.size, value2);
    }

    @Override
    public Object shift(long index) {
        this.handleFrozenArrayValue();
        Object val = this.get(index);
        this.shiftArray((int)index, this.getArrayFromType(this.elementType.getTag()));
        return val;
    }

    @Override
    public Object shift() {
        return this.shift(0L);
    }

    @Override
    public void unshift(BArray values2) {
        this.unshift(0L, (ArrayValue)values2);
    }

    @Override
    public String stringValue() {
        StringJoiner sj = new StringJoiner(" ");
        switch (this.elementType.getTag()) {
            case 1: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                for (int i = 0; i < this.size; ++i) {
                    sj.add(Long.toString(this.intValues[i]));
                }
                break;
            }
            case 6: {
                for (int i = 0; i < this.size; ++i) {
                    sj.add(Boolean.toString(this.booleanValues[i]));
                }
                break;
            }
            case 2: {
                for (int i = 0; i < this.size; ++i) {
                    sj.add(Long.toString(Byte.toUnsignedLong(this.byteValues[i])));
                }
                break;
            }
            case 3: {
                for (int i = 0; i < this.size; ++i) {
                    sj.add(Double.toString(this.floatValues[i]));
                }
                break;
            }
            case 5: 
            case 44: {
                for (int i = 0; i < this.size; ++i) {
                    sj.add(this.stringValues[i]);
                }
                break;
            }
            default: {
                for (int i = 0; i < this.size; ++i) {
                    sj.add(StringUtils.getStringValue(this.refValues[i]));
                }
            }
        }
        return sj.toString();
    }

    @Override
    public BString bStringValue() {
        return null;
    }

    @Override
    public BType getType() {
        return this.arrayType;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        if (this.isFrozen()) {
            return this;
        }
        if (refs.containsKey(this)) {
            return refs.get(this);
        }
        ArrayValueImpl valueArray = null;
        switch (this.elementType.getTag()) {
            case 1: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                valueArray = new ArrayValueImpl(Arrays.copyOf(this.intValues, this.size));
                break;
            }
            case 6: {
                valueArray = new ArrayValueImpl(Arrays.copyOf(this.booleanValues, this.size));
                break;
            }
            case 2: {
                valueArray = new ArrayValueImpl(Arrays.copyOf(this.byteValues, this.size));
                break;
            }
            case 3: {
                valueArray = new ArrayValueImpl(Arrays.copyOf(this.floatValues, this.size));
                break;
            }
            case 5: 
            case 44: {
                valueArray = new ArrayValueImpl(Arrays.copyOf(this.stringValues, this.size));
                break;
            }
            default: {
                Object[] values2 = new Object[this.size];
                valueArray = new ArrayValueImpl(values2, this.arrayType);
                IntStream.range(0, this.size).forEach(i -> {
                    Object value2 = this.refValues[i];
                    values2[i] = value2 instanceof RefValue ? ((RefValue)value2).copy(refs) : value2;
                });
            }
        }
        refs.put(this, valueArray);
        return valueArray;
    }

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        ArrayValue copy = (ArrayValue)this.copy(refs);
        if (!copy.isFrozen()) {
            copy.freezeDirect();
        }
        return copy;
    }

    @Deprecated
    public ArrayValueImpl slice(long startIndex, long endIndex) {
        ArrayValueImpl slicedArray;
        int slicedSize = (int)(endIndex - startIndex);
        switch (this.elementType.getTag()) {
            case 1: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                slicedArray = new ArrayValueImpl(new long[slicedSize]);
                System.arraycopy(this.intValues, (int)startIndex, slicedArray.intValues, 0, slicedSize);
                break;
            }
            case 6: {
                slicedArray = new ArrayValueImpl(new boolean[slicedSize]);
                System.arraycopy(this.booleanValues, (int)startIndex, slicedArray.booleanValues, 0, slicedSize);
                break;
            }
            case 2: {
                slicedArray = new ArrayValueImpl(new byte[slicedSize]);
                System.arraycopy(this.byteValues, (int)startIndex, slicedArray.byteValues, 0, slicedSize);
                break;
            }
            case 3: {
                slicedArray = new ArrayValueImpl(new double[slicedSize]);
                System.arraycopy(this.floatValues, (int)startIndex, slicedArray.floatValues, 0, slicedSize);
                break;
            }
            case 5: 
            case 44: {
                slicedArray = new ArrayValueImpl(new String[slicedSize]);
                System.arraycopy(this.stringValues, (int)startIndex, slicedArray.stringValues, 0, slicedSize);
                break;
            }
            default: {
                slicedArray = new ArrayValueImpl(new Object[slicedSize], new BArrayType(this.elementType));
                System.arraycopy(this.refValues, (int)startIndex, slicedArray.refValues, 0, slicedSize);
            }
        }
        return slicedArray;
    }

    @Override
    public String toString() {
        return this.stringValue();
    }

    @Override
    public Object[] getValues() {
        return this.refValues;
    }

    @Override
    public byte[] getBytes() {
        byte[] bytes = new byte[this.size];
        System.arraycopy(this.byteValues, 0, bytes, 0, this.size);
        return bytes;
    }

    @Override
    public String[] getStringArray() {
        return Arrays.copyOf(this.stringValues, this.size);
    }

    public long[] getLongArray() {
        return Arrays.copyOf(this.intValues, this.size);
    }

    @Override
    public long[] getIntArray() {
        return Arrays.copyOf(this.intValues, this.size);
    }

    @Override
    public void serialize(OutputStream outputStream2) {
        if (this.elementType.getTag() == 2) {
            try {
                for (int i = 0; i < this.size; ++i) {
                    outputStream2.write(this.byteValues[i]);
                }
            }
            catch (IOException e) {
                throw new BallerinaException("error occurred while writing the binary content to the output stream", e);
            }
        }
        try {
            outputStream2.write(this.toString().getBytes(Charset.defaultCharset()));
        }
        catch (IOException e) {
            throw new BallerinaException("error occurred while serializing data", e);
        }
    }

    @Override
    public synchronized void attemptFreeze(Status freezeStatus) {
        if (!FreezeUtils.isOpenForFreeze(this.freezeStatus, freezeStatus)) {
            return;
        }
        this.freezeStatus = freezeStatus;
        if (this.elementType == null || this.elementType.getTag() > 6) {
            for (int i = 0; i < this.size; ++i) {
                Object value2 = this.getRefValue(i);
                if (!(value2 instanceof RefValue)) continue;
                ((RefValue)value2).attemptFreeze(freezeStatus);
            }
        }
    }

    @Override
    public void freezeDirect() {
        if (this.isFrozen()) {
            return;
        }
        this.freezeStatus.setFrozen();
        if (this.elementType == null || this.elementType.getTag() > 6) {
            for (int i = 0; i < this.size; ++i) {
                Object value2 = this.getRefValue(i);
                if (!(value2 instanceof RefValue)) continue;
                ((RefValue)value2).freezeDirect();
            }
        }
    }

    @Override
    public synchronized boolean isFrozen() {
        return this.freezeStatus.isFrozen();
    }

    @Override
    public IteratorValue getIterator() {
        return new AbstractArrayValue.ArrayIterator(this);
    }

    @Override
    public BType getElementType() {
        return this.elementType;
    }

    @Override
    protected void resizeInternalArray(int newLength) {
        switch (this.elementType.getTag()) {
            case 1: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                this.intValues = Arrays.copyOf(this.intValues, newLength);
                break;
            }
            case 6: {
                this.booleanValues = Arrays.copyOf(this.booleanValues, newLength);
                break;
            }
            case 2: {
                this.byteValues = Arrays.copyOf(this.byteValues, newLength);
                break;
            }
            case 3: {
                this.floatValues = Arrays.copyOf(this.floatValues, newLength);
                break;
            }
            case 5: 
            case 44: {
                this.stringValues = Arrays.copyOf(this.stringValues, newLength);
                break;
            }
            default: {
                this.refValues = Arrays.copyOf(this.refValues, newLength);
            }
        }
    }

    @Override
    protected void fillValues(int index) {
        if (index <= this.size) {
            return;
        }
        switch (this.elementType.getTag()) {
            case 5: {
                Arrays.fill(this.stringValues, this.size, index, "");
                return;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                return;
            }
        }
        if (this.arrayType.hasFillerValue()) {
            for (int i = this.size; i < index; ++i) {
                this.refValues[i] = this.elementType.getZeroValue();
            }
        }
    }

    @Override
    protected void rangeCheckForGet(long index, int size) {
        this.rangeCheck(index, size);
        if (index >= (long)size) {
            throw BLangExceptionHelper.getRuntimeException(BallerinaErrorReasons.getModulePrefixedReason("lang.array", "IndexOutOfRange"), RuntimeErrors.ARRAY_INDEX_OUT_OF_RANGE, index, size);
        }
    }

    @Override
    protected void rangeCheck(long index, int size) {
        if (index > Integer.MAX_VALUE || index < Integer.MIN_VALUE) {
            throw BLangExceptionHelper.getRuntimeException(BallerinaErrorReasons.getModulePrefixedReason("lang.array", "IndexOutOfRange"), RuntimeErrors.INDEX_NUMBER_TOO_LARGE, index);
        }
        if ((int)index < 0 || index >= (long)this.maxSize) {
            throw BLangExceptionHelper.getRuntimeException(BallerinaErrorReasons.getModulePrefixedReason("lang.array", "IndexOutOfRange"), RuntimeErrors.ARRAY_INDEX_OUT_OF_RANGE, index, size);
        }
    }

    @Override
    protected void fillerValueCheck(int index, int size) {
        if (this.arrayType.hasFillerValue()) {
            return;
        }
        if (index > size) {
            throw BLangExceptionHelper.getRuntimeException(BallerinaErrorReasons.ILLEGAL_LIST_INSERTION_ERROR, RuntimeErrors.ILLEGAL_ARRAY_INSERTION, size, index + 1);
        }
    }

    @Override
    protected void ensureCapacity(int requestedCapacity, int currentArraySize) {
        if (requestedCapacity <= currentArraySize) {
            return;
        }
        if (this.arrayType.getState() != ArrayState.UNSEALED) {
            return;
        }
        int newArraySize = currentArraySize + (currentArraySize >> 1);
        newArraySize = Math.max(newArraySize, requestedCapacity);
        newArraySize = Math.min(newArraySize, this.maxSize);
        this.resizeInternalArray(newArraySize);
    }

    @Override
    protected void checkFixedLength(long length) {
        if (this.arrayType.getState() == ArrayState.CLOSED_SEALED) {
            throw BLangExceptionHelper.getRuntimeException(BallerinaErrorReasons.getModulePrefixedReason("lang.array", "InherentTypeViolation"), RuntimeErrors.ILLEGAL_ARRAY_SIZE, this.size, length);
        }
    }

    @Override
    protected void unshift(long index, ArrayValue vals) {
        this.handleFrozenArrayValue();
        this.unshiftArray(index, vals.size(), this.getCurrentArrayLength());
        int startIndex = (int)index;
        int endIndex = startIndex + vals.size();
        int i = startIndex;
        int j = 0;
        while (i < endIndex) {
            this.add((long)i, vals.get(j));
            ++i;
            ++j;
        }
    }

    private void prepareForAdd(long index, Object value2, BType sourceType, int currentArraySize) {
        if (!TypeChecker.checkIsType(value2, sourceType, this.elementType)) {
            throw BallerinaErrors.createError(BallerinaErrorReasons.getModulePrefixedReason("lang.array", "InherentTypeViolation"), BLangExceptionHelper.getErrorMessage(RuntimeErrors.INCOMPATIBLE_TYPE, this.elementType, sourceType));
        }
        int intIndex = (int)index;
        this.rangeCheck(index, this.size);
        this.fillerValueCheck(intIndex, this.size);
        this.ensureCapacity(intIndex + 1, currentArraySize);
        this.fillValues(intIndex);
        this.resetSize(intIndex);
    }

    private void fillRead(long index, int currentArraySize) {
        if (!this.arrayType.hasFillerValue()) {
            throw BLangExceptionHelper.getRuntimeException(BallerinaErrorReasons.ILLEGAL_LIST_INSERTION_ERROR, RuntimeErrors.ILLEGAL_ARRAY_INSERTION, this.size, index + 1L);
        }
        int intIndex = (int)index;
        this.rangeCheck(index, this.size);
        this.ensureCapacity(intIndex + 1, currentArraySize);
        switch (this.elementType.getTag()) {
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 5: {
                Arrays.fill(this.stringValues, this.size, intIndex, "");
                break;
            }
            default: {
                int i = this.size;
                while ((long)i <= index) {
                    this.refValues[i] = this.elementType.getZeroValue();
                    ++i;
                }
                break block0;
            }
        }
        this.resetSize(intIndex);
    }

    private void setArrayType(BType elementType) {
        this.arrayType = new BArrayType(elementType);
        this.elementType = elementType;
    }

    private void resetSize(int index) {
        if (index >= this.size) {
            this.size = index + 1;
        }
    }

    private void shiftArray(int index, Object arr) {
        int nElemsToBeMoved = this.size - 1 - index;
        if (nElemsToBeMoved >= 0) {
            System.arraycopy(arr, index + 1, arr, index, nElemsToBeMoved);
        }
        --this.size;
    }

    private void unshiftArray(long index, int unshiftByN, int arrLength) {
        int lastIndex = this.size() + unshiftByN - 1;
        this.prepareForConsecutiveMultiAdd(lastIndex, arrLength);
        Object arr = this.getArrayFromType(this.elementType.getTag());
        if (index > (long)lastIndex) {
            throw BLangExceptionHelper.getRuntimeException(BallerinaErrorReasons.getModulePrefixedReason("lang.array", "IndexOutOfRange"), RuntimeErrors.INDEX_NUMBER_TOO_LARGE, index);
        }
        int i = (int)index;
        System.arraycopy(arr, i, arr, i + unshiftByN, this.size - i);
    }

    private Object getArrayFromType(int typeTag) {
        switch (typeTag) {
            case 1: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                return this.intValues;
            }
            case 6: {
                return this.booleanValues;
            }
            case 2: {
                return this.byteValues;
            }
            case 3: {
                return this.floatValues;
            }
            case 5: 
            case 44: {
                return this.stringValues;
            }
        }
        return this.refValues;
    }

    private int getCurrentArrayLength() {
        switch (this.elementType.getTag()) {
            case 1: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                return this.intValues.length;
            }
            case 6: {
                return this.booleanValues.length;
            }
            case 2: {
                return this.byteValues.length;
            }
            case 3: {
                return this.floatValues.length;
            }
            case 5: 
            case 44: {
                return this.stringValues.length;
            }
        }
        return this.refValues.length;
    }
}

