/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.jvm.values;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;
import org.ballerinalang.jvm.JSONDataSource;
import org.ballerinalang.jvm.JSONGenerator;
import org.ballerinalang.jvm.JSONUtils;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BMapType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.AbstractArrayValue;
import org.ballerinalang.jvm.values.ArrayValueImpl;
import org.ballerinalang.jvm.values.IteratorValue;
import org.ballerinalang.jvm.values.api.BStreamingJson;
import org.ballerinalang.jvm.values.api.BString;

public class StreamingJsonValue
extends ArrayValueImpl
implements BStreamingJson {
    JSONDataSource datasource;

    @Deprecated
    public StreamingJsonValue(JSONDataSource datasource) {
        super(new BArrayType(new BMapType(BTypes.typeJSON)));
        this.datasource = datasource;
    }

    @Override
    public void add(long index, Object value2) {
        while (index >= (long)this.size && this.datasource.hasNext()) {
            this.appendToCache(this.datasource.next());
        }
        super.add(index, value2);
    }

    @Override
    public void append(Object value2) {
        if (this.datasource.hasNext()) {
            this.buildDatasource();
        }
        super.append(value2);
    }

    @Override
    public Object getRefValue(long index) {
        while (index >= (long)this.size && this.datasource.hasNext()) {
            this.appendToCache(this.datasource.next());
        }
        return super.getRefValue(index);
    }

    @Override
    public void serialize(JSONGenerator gen) {
        try {
            gen.writeStartArray();
            for (int i = 0; i < this.size; ++i) {
                gen.serialize(this.refValues[i]);
            }
            while (this.datasource.hasNext()) {
                gen.serialize(this.datasource.next());
            }
            gen.writeEndArray();
            gen.flush();
        }
        catch (IOException e) {
            throw JSONUtils.createJsonConversionError(e, "error occurred while serializing data");
        }
    }

    @Override
    public void serialize(Writer writer) {
        try (JSONGenerator gen = new JSONGenerator(writer);){
            this.serialize(gen);
        }
        catch (IOException e) {
            throw JSONUtils.createJsonConversionError(e, "error occurred while serializing data");
        }
    }

    @Override
    public void serialize(OutputStream outputStream2) {
        try (JSONGenerator gen = new JSONGenerator(outputStream2);){
            this.serialize(gen);
        }
        catch (IOException e) {
            throw JSONUtils.createJsonConversionError(e, "error occurred while serializing data");
        }
    }

    @Override
    public Object[] getValues() {
        if (this.datasource.hasNext()) {
            this.buildDatasource();
        }
        return this.refValues;
    }

    @Override
    public String toString() {
        if (this.datasource.hasNext()) {
            this.buildDatasource();
        }
        return super.toString();
    }

    @Override
    public String stringValue() {
        if (this.datasource.hasNext()) {
            this.buildDatasource();
        }
        return super.stringValue();
    }

    @Override
    public int size() {
        if (this.datasource.hasNext()) {
            this.buildDatasource();
        }
        return this.size;
    }

    void appendToCache(Object value2) {
        super.add((long)this.size, value2);
    }

    @Override
    public String getJSONString() {
        this.buildDatasource();
        return super.getJSONString();
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        this.buildDatasource();
        return super.copy(refs);
    }

    private void buildDatasource() {
        try {
            while (this.datasource.hasNext()) {
                this.appendToCache(this.datasource.next());
            }
        }
        catch (Throwable t) {
            throw JSONUtils.createJsonConversionError(t, "error occurred while building JSON");
        }
    }

    @Override
    public IteratorValue getIterator() {
        return new AbstractArrayValue.ArrayIterator(this);
    }

    static class StreamingJsonIterator
    implements IteratorValue {
        StreamingJsonValue array;
        long cursor = 0L;

        StreamingJsonIterator(StreamingJsonValue value2) {
            this.array = value2;
        }

        public Object next() {
            Object value2;
            if (this.cursor < (long)this.array.size) {
                value2 = this.array.get(this.cursor);
            } else {
                value2 = this.array.datasource.next();
                this.array.appendToCache(value2);
            }
            ++this.cursor;
            return value2;
        }

        @Override
        public boolean hasNext() {
            if (this.cursor < (long)this.array.size) {
                return true;
            }
            return this.array.datasource.hasNext();
        }

        @Override
        public BString bStringValue() {
            return null;
        }
    }
}

