/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.array;

import java.util.Arrays;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BTupleType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.types.BUnionType;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ArrayValueImpl;
import org.ballerinalang.jvm.values.TupleValueImpl;
import org.ballerinalang.jvm.values.api.BArray;
import org.ballerinalang.jvm.values.utils.ArrayUtils;
import org.ballerinalang.jvm.values.utils.GetFunction;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="lang.array", functionName="enumerate", args={@Argument(name="arr", type=TypeKind.ARRAY)}, returnType={@ReturnType(type=TypeKind.ARRAY, elementType=TypeKind.TUPLE)}, isPublic=true)
public class Enumerate {
    public static ArrayValue enumerate(Strand strand, ArrayValue arr) {
        GetFunction getFn;
        BTupleType elemType;
        BType arrType = arr.getType();
        int size = arr.size();
        switch (arrType.getTag()) {
            case 20: {
                elemType = new BTupleType(Arrays.asList(BTypes.typeInt, arr.getElementType()));
                getFn = BArray::get;
                break;
            }
            case 31: {
                BTupleType tupleType = (BTupleType)arrType;
                BUnionType tupElemType = new BUnionType(tupleType.getTupleTypes(), tupleType.getTypeFlags());
                elemType = new BTupleType(Arrays.asList(BTypes.typeInt, tupElemType));
                getFn = BArray::getRefValue;
                break;
            }
            default: {
                throw ArrayUtils.createOpNotSupportedError(arrType, "enumerate()");
            }
        }
        BArrayType newArrType = new BArrayType(elemType);
        ArrayValueImpl newArr = new ArrayValueImpl(newArrType);
        for (int i = 0; i < size; ++i) {
            TupleValueImpl entry = new TupleValueImpl(elemType);
            entry.add(0L, (Object)i);
            entry.add(1L, getFn.get(arr, i));
            newArr.add((long)i, entry);
        }
        return newArr;
    }
}

