/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.array;

import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BFunctionType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ArrayValueImpl;
import org.ballerinalang.jvm.values.FPValue;
import org.ballerinalang.jvm.values.api.BArray;
import org.ballerinalang.jvm.values.utils.ArrayUtils;
import org.ballerinalang.jvm.values.utils.GetFunction;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="lang.array", functionName="map", args={@Argument(name="arr", type=TypeKind.ARRAY), @Argument(name="func", type=TypeKind.FUNCTION)}, returnType={@ReturnType(type=TypeKind.ARRAY)}, isPublic=true)
public class Map {
    public static ArrayValue map(Strand strand, ArrayValue arr, FPValue<Object, Object> func) {
        GetFunction getFn;
        BType elemType = ((BFunctionType)func.getType()).retType;
        BArrayType retArrType = new BArrayType(elemType);
        ArrayValueImpl retArr = new ArrayValueImpl(retArrType);
        int size = arr.size();
        BType arrType = arr.getType();
        switch (arrType.getTag()) {
            case 20: {
                getFn = BArray::get;
                break;
            }
            case 31: {
                getFn = BArray::getRefValue;
                break;
            }
            default: {
                throw ArrayUtils.createOpNotSupportedError(arrType, "map()");
            }
        }
        for (int i = 0; i < size; ++i) {
            Object newVal = func.getFunction().apply(new Object[]{strand, getFn.get(arr, i), true});
            retArr.add((long)i, newVal);
        }
        return retArr;
    }
}

