/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.map;

import org.ballerinalang.jvm.MapUtils;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BMapType;
import org.ballerinalang.jvm.types.BRecordType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.values.FPValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.langlib.map.util.MapLibUtils;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="lang.map", functionName="filter", args={@Argument(name="m", type=TypeKind.MAP), @Argument(name="func", type=TypeKind.FUNCTION)}, returnType={@ReturnType(type=TypeKind.MAP)}, isPublic=true)
public class Filter {
    public static MapValue filter(Strand strand, MapValue<?, ?> m, FPValue<Object, Boolean> func) {
        BType newMapType;
        BType mapType = m.getType();
        switch (mapType.getTag()) {
            case 15: {
                newMapType = mapType;
                break;
            }
            case 12: {
                BType newConstraint = MapLibUtils.getCommonTypeForRecordField((BRecordType)mapType);
                newMapType = new BMapType(newConstraint);
                break;
            }
            default: {
                throw MapUtils.createOpNotSupportedError(mapType, "filter()");
            }
        }
        MapValueImpl newMap = new MapValueImpl(newMapType);
        m.entrySet().forEach(entry -> {
            if (((Boolean)func.apply(new Object[]{strand, entry.getValue(), true})).booleanValue()) {
                newMap.put(entry.getKey(), entry.getValue());
            }
        });
        return newMap;
    }
}

