/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.string;

import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.util.exceptions.BLangExceptionHelper;
import org.ballerinalang.jvm.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.jvm.util.exceptions.RuntimeErrors;
import org.ballerinalang.langlib.string.utils.StringUtils;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;

@BallerinaFunction(orgName="ballerina", packageName="lang.string", functionName="lastIndexOf", args={@Argument(name="s", type=TypeKind.STRING), @Argument(name="substring", type=TypeKind.STRING)}, returnType={@ReturnType(type=TypeKind.UNION)}, isPublic=true)
public class LastIndexOf {
    public static Object lastIndexOf(Strand strand, String value2, String subString, long startIndex) {
        StringUtils.checkForNull(value2, subString);
        if (startIndex > Integer.MAX_VALUE) {
            throw BLangExceptionHelper.getRuntimeException(BallerinaErrorReasons.getModulePrefixedReason("lang.string", "IndexOutOfRange"), RuntimeErrors.INDEX_NUMBER_TOO_LARGE, startIndex);
        }
        long index = value2.lastIndexOf(subString, (int)startIndex);
        return index >= 0L ? Long.valueOf(index) : null;
    }
}

