/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.xml;

import java.util.Arrays;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.XMLFactory;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.types.BUnionType;
import org.ballerinalang.jvm.types.TypeFlags;
import org.ballerinalang.jvm.util.exceptions.BLangExceptionHelper;
import org.ballerinalang.jvm.util.exceptions.RuntimeErrors;
import org.ballerinalang.jvm.values.XMLValue;
import org.ballerinalang.langlib.xml.IsElement;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;

@BallerinaFunction(orgName="ballerina", packageName="lang.xml", functionName="setChildren", args={@Argument(name="children", type=TypeKind.UNION)}, isPublic=true)
public class SetChildren {
    private static final String OPERATION = "set children to xml element";

    public static void setChildren(Strand strand, XMLValue xml2, Object children) {
        if (!IsElement.isElement(strand, xml2)) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.XML_FUNC_TYPE_ERROR, "setChildren", "element");
        }
        BType childrenType = TypeChecker.getType(children);
        if (childrenType.getTag() == 5) {
            XMLValue xmlText = XMLFactory.createXMLText((String)children);
            children = xmlText;
        } else if (childrenType.getTag() != 8) {
            BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE, new BUnionType(Arrays.asList(BTypes.typeXML, BTypes.typeString), TypeFlags.asMask(2, 4)), childrenType);
        }
        try {
            xml2.setChildren((XMLValue)children);
        }
        catch (Throwable e) {
            BLangExceptionHelper.handleXMLException(OPERATION, e);
        }
    }
}

