/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model;

public class NodeLocation {
    private String pkgDirPath;
    private String fileName;
    private int lineNumber = -1;
    public int startLineNumber = -1;
    public int startColumn = -1;
    public int stopLineNumber = -1;
    public int stopColumn = -1;

    public NodeLocation(String fileName, int lineNumber) {
        this.fileName = fileName;
        this.lineNumber = lineNumber;
    }

    public NodeLocation(String pkgDirPath, String fileName, int lineNumber) {
        this(fileName, lineNumber);
        this.pkgDirPath = pkgDirPath;
    }

    public NodeLocation(String pkgDirPath, String fileName, int lineNumber, int startLineNumber, int startColumn, int stopLineNumber, int stopColumn) {
        this(pkgDirPath, fileName, lineNumber);
        this.startLineNumber = startLineNumber;
        this.startColumn = startColumn;
        this.stopLineNumber = stopLineNumber;
        this.stopColumn = stopColumn;
    }

    public String getPackageDirPath() {
        return this.pkgDirPath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NodeLocation)) {
            return false;
        }
        NodeLocation other = (NodeLocation)obj;
        return this.fileName.equals(other.getFileName()) && this.lineNumber == other.getLineNumber();
    }

    public int hashCode() {
        int result = this.fileName.hashCode() + this.lineNumber;
        result = 31 * result;
        return result;
    }

    public String toString() {
        return this.fileName + ":" + this.lineNumber;
    }
}

