/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.util.serializer.providers.bvalue;

import java.util.HashMap;
import java.util.LinkedHashMap;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.util.serializer.BPacket;
import org.ballerinalang.model.util.serializer.BValueDeserializer;
import org.ballerinalang.model.util.serializer.BValueSerializer;
import org.ballerinalang.model.util.serializer.SerializationBValueProvider;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BValue;

public class BMapBValueProvider
implements SerializationBValueProvider<BMap> {
    private static final String MAP_STORAGE_TYPE = "#MAP_TYPE";

    @Override
    public String typeName() {
        return BMap.class.getSimpleName();
    }

    @Override
    public Class<?> getType() {
        return BMap.class;
    }

    @Override
    public BPacket toBValue(BMap bMap, BValueSerializer serializer) {
        BValue value2 = serializer.toBValue(bMap.getType(), null);
        LinkedHashMap implMap = bMap.getMap();
        BValue serialized = serializer.toBValue(implMap, implMap.getClass());
        return BPacket.from(this.typeName(), serialized).put(MAP_STORAGE_TYPE, value2);
    }

    @Override
    public BMap toObject(BPacket packet, BValueDeserializer bValueDeserializer) {
        BMap payload = (BMap)packet.getValue();
        BType type = (BType)bValueDeserializer.deserialize(packet.get(MAP_STORAGE_TYPE), BType.class);
        bValueDeserializer.addObjReference((BMap)packet.get(MAP_STORAGE_TYPE), type);
        BMap bMap = new BMap(type);
        bValueDeserializer.addObjReference(packet.toBMap(), bMap);
        HashMap deserializedMap = (HashMap)bValueDeserializer.deserialize(payload, HashMap.class);
        bMap.getMap().putAll(deserializedMap);
        return bMap;
    }
}

