/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.values;

import java.lang.reflect.Array;
import org.ballerinalang.model.types.BArrayType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.values.BCollection;
import org.ballerinalang.model.values.BIterator;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.util.exceptions.BLangExceptionHelper;
import org.ballerinalang.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.util.exceptions.RuntimeErrors;
import org.wso2.ballerinalang.compiler.util.BArrayState;

public abstract class BNewArray
implements BRefType,
BCollection {
    protected BType arrayType;
    protected int maxArraySize = 0x7FFFFFF7;
    private static final int DEFAULT_ARRAY_SIZE = 100;
    protected int size = 0;

    public abstract void grow(int var1);

    @Override
    public String stringValue() {
        return null;
    }

    @Override
    public BType getType() {
        return this.arrayType;
    }

    public BRefType<?> value() {
        return null;
    }

    protected Object newArrayInstance(Class<?> componentType) {
        return this.size > 0 ? Array.newInstance(componentType, this.size) : Array.newInstance(componentType, 100);
    }

    protected void prepareForAdd(long index, int currentArraySize) {
        int intIndex = (int)index;
        this.rangeCheck(index, this.size);
        this.ensureCapacity(intIndex + 1, currentArraySize);
        this.resetSize(intIndex);
    }

    protected void resetSize(int index) {
        if (index >= this.size) {
            this.size = index + 1;
        }
    }

    protected void rangeCheck(long index, int size) {
        if (index > Integer.MAX_VALUE || index < Integer.MIN_VALUE) {
            throw BLangExceptionHelper.getRuntimeException(BallerinaErrorReasons.INDEX_OUT_OF_RANGE_ERROR, RuntimeErrors.INDEX_NUMBER_TOO_LARGE, index);
        }
        if ((int)index < 0 || index >= (long)this.maxArraySize) {
            if (this.arrayType != null && this.arrayType.getTag() == 29) {
                throw BLangExceptionHelper.getRuntimeException(BallerinaErrorReasons.INDEX_OUT_OF_RANGE_ERROR, RuntimeErrors.TUPLE_INDEX_OUT_OF_RANGE, index, size);
            }
            throw BLangExceptionHelper.getRuntimeException(BallerinaErrorReasons.INDEX_OUT_OF_RANGE_ERROR, RuntimeErrors.ARRAY_INDEX_OUT_OF_RANGE, index, size);
        }
    }

    protected void rangeCheckForGet(long index, int size) {
        this.rangeCheck(index, size);
        if (index < 0L || index >= (long)size) {
            throw BLangExceptionHelper.getRuntimeException(BallerinaErrorReasons.INDEX_OUT_OF_RANGE_ERROR, RuntimeErrors.ARRAY_INDEX_OUT_OF_RANGE, index, size);
        }
    }

    protected void ensureCapacity(int requestedCapacity, int currentArraySize) {
        if (requestedCapacity - currentArraySize >= 0 && this.arrayType.getTag() == 19 && ((BArrayType)this.arrayType).getState() == BArrayState.UNSEALED) {
            int newArraySize = currentArraySize + (currentArraySize >> 1);
            newArraySize = Math.max(newArraySize, requestedCapacity);
            newArraySize = Math.min(newArraySize, this.maxArraySize);
            this.grow(newArraySize);
        }
    }

    @Override
    public long size() {
        return this.size;
    }

    public abstract BValue getBValue(long var1);

    @Override
    public BIterator newIterator() {
        return new BArrayIterator(this);
    }

    @Override
    public synchronized boolean isFrozen() {
        return true;
    }

    static class BArrayIterator
    implements BIterator {
        BNewArray array;
        long cursor = 0L;
        long length;

        BArrayIterator(BNewArray value2) {
            this.array = value2;
            this.length = value2.size();
        }

        @Override
        public BValue getNext() {
            long cursor;
            if ((cursor = this.cursor++) == this.length) {
                return null;
            }
            return this.array.getBValue(cursor);
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.length;
        }
    }
}

