/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.observe.metrics.prometheus;

import java.io.PrintStream;
import java.util.Optional;
import org.ballerinalang.config.ConfigRegistry;
import org.ballerinalang.jvm.observability.InvalidConfigurationException;
import org.ballerinalang.jvm.observability.metrics.spi.MetricReporter;
import org.ballerinalang.jvm.services.EmbeddedExecutorProvider;
import org.ballerinalang.jvm.services.spi.EmbeddedExecutor;

public class PrometheusReporter
implements MetricReporter {
    private static final PrintStream console = System.out;
    private static final String PROMETHEUS_PACKAGE = "prometheus";
    private static final String PROMETHEUS_HOST_CONFIG = "b7a.observability.metrics.prometheus.host";
    private static final String PROMETHEUS_PORT_CONFIG = "b7a.observability.metrics.prometheus.port";
    private static final String DEFAULT_PROMETHEUS_HOST = "0.0.0.0";
    private static final String DEFAULT_PROMETHEUS_PORT = "9797";

    @Override
    public void init() throws InvalidConfigurationException {
        String hostname = ConfigRegistry.getInstance().getConfigOrDefault(PROMETHEUS_HOST_CONFIG, DEFAULT_PROMETHEUS_HOST);
        String port = ConfigRegistry.getInstance().getConfigOrDefault(PROMETHEUS_PORT_CONFIG, DEFAULT_PROMETHEUS_PORT);
        EmbeddedExecutor executor = EmbeddedExecutorProvider.getInstance().getExecutor();
        Optional<RuntimeException> prometheus2 = executor.executeService(PROMETHEUS_PACKAGE);
        if (prometheus2.isPresent()) {
            console.println("ballerina: failed to start Prometheus HTTP listener " + hostname + ":" + port + " " + prometheus2.get().getMessage());
            return;
        }
        console.println("ballerina: started Prometheus HTTP listener " + hostname + ":" + port);
    }

    @Override
    public String getName() {
        return PROMETHEUS_PACKAGE;
    }
}

