/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.observe.nativeimpl;

import java.time.Duration;
import java.util.Map;
import org.ballerinalang.jvm.observability.metrics.Gauge;
import org.ballerinalang.jvm.observability.metrics.Metric;
import org.ballerinalang.jvm.observability.metrics.StatisticConfig;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.observe.nativeimpl.Utils;

@BallerinaFunction(orgName="ballerina", packageName="observe", functionName="initialize", receiver=@Receiver(type=TypeKind.OBJECT, structType="Gauge", structPackage="ballerina/observe"))
public class GaugeInitialize {
    public static void initialize(Strand strand, ObjectValue guage) {
        ArrayValue summaryConfigs = (ArrayValue)guage.get("statisticConfigs");
        Metric.Builder gaugeBuilder = Gauge.builder((String)guage.get("name")).description((String)guage.get("description")).tags((Map)Utils.toStringMap((MapValue)guage.get("metricTags")));
        if (summaryConfigs != null && summaryConfigs.size() > 0) {
            for (int i = 0; i < summaryConfigs.size(); ++i) {
                MapValue summaryConfigStruct = (MapValue)summaryConfigs.get(i);
                StatisticConfig.Builder statisticBuilder = StatisticConfig.builder().expiry(Duration.ofMillis((Long)summaryConfigStruct.get("timeWindow"))).buckets((Long)summaryConfigStruct.get("buckets"));
                ArrayValue bFloatArray = (ArrayValue)summaryConfigStruct.get("percentiles");
                double[] percentiles = new double[bFloatArray.size()];
                for (int j = 0; j < bFloatArray.size(); ++j) {
                    percentiles[j] = bFloatArray.getFloat(j);
                }
                statisticBuilder.percentiles(percentiles);
                StatisticConfig config = statisticBuilder.build();
                ((Gauge.Builder)gaugeBuilder).summarize(config);
            }
        }
        Gauge gauge = ((Gauge.Builder)gaugeBuilder).build();
        guage.addNativeData("__metric_native_instance__", gauge);
    }
}

