/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.observe.nativeimpl;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.ballerinalang.config.ConfigRegistry;
import org.ballerinalang.jvm.observability.ObserveUtils;
import org.ballerinalang.jvm.observability.ObserverContext;
import org.ballerinalang.jvm.observability.OtelTracingUtils;
import org.ballerinalang.jvm.observability.TracingUtils;
import org.ballerinalang.jvm.observability.tracer.OtelTracersStore;
import org.ballerinalang.jvm.observability.tracer.TracersStore;
import org.ballerinalang.jvm.scheduling.Strand;

public class OpenTracerBallerinaWrapper {
    private static OpenTracerBallerinaWrapper instance = new OpenTracerBallerinaWrapper();
    private TracersStore tracerStore;
    private OtelTracersStore otelTracersStore;
    private final boolean enabled;
    private ConcurrentMap<Long, ObserverContext> observerContextList = new ConcurrentHashMap<Long, ObserverContext>();
    private AtomicLong spanId = new AtomicLong();
    private static final int SYSTEM_TRACE_INDICATOR = -1;
    static final int ROOT_SPAN_INDICATOR = -2;

    private OpenTracerBallerinaWrapper() {
        this.enabled = ConfigRegistry.getInstance().getAsBoolean("b7a.observability.tracing.enabled");
        this.tracerStore = TracersStore.getInstance();
        this.otelTracersStore = OtelTracersStore.getInstance();
    }

    public static OpenTracerBallerinaWrapper getInstance() {
        return instance;
    }

    private long startSpan(ObserverContext observerContext, boolean isClient, String spanName) {
        observerContext.setActionName(spanName);
        if (ObserveUtils.getTracingProtocol().equals("opentelemetry")) {
            OtelTracingUtils.startObservation(observerContext, isClient);
        } else {
            TracingUtils.startObservation(observerContext, isClient);
        }
        long spanId = this.spanId.getAndIncrement();
        this.observerContextList.put(spanId, observerContext);
        return spanId;
    }

    public long startSpan(String serviceName, String spanName, Map<String, String> tags, long parentSpanId, Strand strand) {
        if (!this.enabled) {
            return -1L;
        }
        if (serviceName == null) {
            serviceName = "Unknown Service";
        }
        if (ObserveUtils.getTracingProtocol().equals("opentelemetry") ? this.otelTracersStore.getTracer(serviceName) == null : this.tracerStore.getTracer(serviceName) == null) {
            return -1L;
        }
        ObserverContext observerContext = new ObserverContext();
        observerContext.setServiceName(serviceName);
        observerContext.setResourceName(spanName);
        tags.forEach(observerContext::addTag);
        if (parentSpanId == -1L) {
            observerContext.setSystemSpan(true);
            ObserveUtils.getObserverContextOfCurrentFrame(strand).ifPresent(observerContext::setParent);
            ObserveUtils.setObserverContextToCurrentFrame(strand, observerContext);
            return this.startSpan(observerContext, true, spanName);
        }
        if (parentSpanId != -2L) {
            ObserverContext parentOContext = (ObserverContext)this.observerContextList.get(parentSpanId);
            if (parentOContext == null) {
                return -1L;
            }
            observerContext.setParent(parentOContext);
            return this.startSpan(observerContext, true, spanName);
        }
        return this.startSpan(observerContext, false, spanName);
    }

    public boolean finishSpan(Strand strand, long spanId) {
        if (!this.enabled) {
            return false;
        }
        ObserverContext observerContext = (ObserverContext)this.observerContextList.get(spanId);
        if (observerContext != null) {
            if (observerContext.isSystemSpan()) {
                ObserveUtils.setObserverContextToCurrentFrame(strand, observerContext.getParent());
            }
            if (ObserveUtils.getTracingProtocol().equals("opentelemetry")) {
                OtelTracingUtils.stopObservation(observerContext);
            } else {
                TracingUtils.stopObservation(observerContext);
            }
            observerContext.setFinished();
            this.observerContextList.remove(spanId);
            return true;
        }
        return false;
    }

    public boolean addTag(String tagKey, String tagValue, long spanId, Strand strand) {
        Optional<ObserverContext> observer;
        if (!this.enabled) {
            return false;
        }
        ObserverContext observerContext = (ObserverContext)this.observerContextList.get(spanId);
        if (spanId == -1L && (observer = ObserveUtils.getObserverContextOfCurrentFrame(strand)).isPresent()) {
            observer.get().addTag(tagKey, tagValue);
            return true;
        }
        if (observerContext != null) {
            observerContext.addTag(tagKey, tagValue);
            return true;
        }
        return false;
    }
}

