/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.observe.trace.extension.jaeger;

import io.grpc.ManagedChannel;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelProvider;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.semconv.ResourceAttributes;
import java.io.PrintStream;
import java.util.concurrent.TimeUnit;
import org.ballerinalang.config.ConfigRegistry;
import org.ballerinalang.jvm.observability.InvalidConfigurationException;
import org.ballerinalang.jvm.observability.tracer.spi.TracerProvider;
import org.ballerinalang.observe.trace.extension.jaeger.sampler.RateLimitingSampler;

public class JaegerTracerProvider
implements TracerProvider {
    private ConfigRegistry configRegistry;
    private String hostname;
    private int port;
    private String samplerType;
    private Number samplerParam;
    private int reporterFlushInterval;
    private int reporterBufferSize;
    private static final PrintStream console = System.out;
    private SdkTracerProviderBuilder tracerProviderBuilder;

    @Override
    public String getName() {
        return "jaeger";
    }

    @Override
    public void init() throws InvalidConfigurationException {
        this.configRegistry = ConfigRegistry.getInstance();
        try {
            this.port = Integer.parseInt(this.configRegistry.getConfigOrDefault("b7a.observability.tracing.jaeger.reporter.port", String.valueOf(4317)));
            this.hostname = this.configRegistry.getConfigOrDefault("b7a.observability.tracing.jaeger.reporter.hostname", "localhost");
            this.samplerType = this.configRegistry.getConfigOrDefault("b7a.observability.tracing.jaeger.sampler.type", "const");
            this.samplerParam = Float.valueOf(this.configRegistry.getConfigOrDefault("b7a.observability.tracing.jaeger.sampler.param", String.valueOf(1)));
            this.reporterFlushInterval = Integer.parseInt(this.configRegistry.getConfigOrDefault("b7a.observability.tracing.jaeger.reporter.flush.interval.ms", String.valueOf(1000)));
            this.reporterBufferSize = Integer.parseInt(this.configRegistry.getConfigOrDefault("b7a.observability.tracing.jaeger.reporter.max.buffer.spans", String.valueOf(10000)));
        }
        catch (ArithmeticException | IllegalArgumentException e) {
            throw new InvalidConfigurationException(e.getMessage());
        }
        String reporterEndpoint = this.hostname + ":" + this.port;
        ManagedChannel jaegerChannel = new NettyChannelProvider().builderForTarget(reporterEndpoint).usePlaintext().build();
        OtlpGrpcSpanExporter exporter = OtlpGrpcSpanExporter.builder().setChannel(jaegerChannel).build();
        this.tracerProviderBuilder = SdkTracerProvider.builder().addSpanProcessor(BatchSpanProcessor.builder(exporter).setMaxExportBatchSize(this.reporterBufferSize).setExporterTimeout(this.reporterFlushInterval, TimeUnit.MILLISECONDS).build());
        this.tracerProviderBuilder.setSampler(JaegerTracerProvider.selectSampler(this.samplerType, this.samplerParam));
        console.println("ballerina: started publishing tracers to Jaeger on " + reporterEndpoint);
    }

    private static Sampler selectSampler(String samplerType, Number samplerParam) {
        switch (samplerType) {
            default: {
                if (samplerParam.intValue() == 0) {
                    return Sampler.alwaysOff();
                }
                return Sampler.alwaysOn();
            }
            case "probabilistic": {
                return Sampler.traceIdRatioBased(samplerParam.doubleValue());
            }
            case "ratelimiting": 
        }
        return new RateLimitingSampler(samplerParam.intValue());
    }

    @Override
    public Tracer getTracer(String serviceName) {
        return this.tracerProviderBuilder.setResource(Resource.create(Attributes.of(ResourceAttributes.SERVICE_NAME, serviceName))).build().get("jaeger");
    }

    @Override
    public ContextPropagators getPropagators() {
        return ContextPropagators.create(W3CTraceContextPropagator.getInstance());
    }
}

