/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.Table;

public class AlterTableRename
extends SchemaCommand {
    private boolean ifTableExists;
    private String oldTableName;
    private String newTableName;
    private boolean hidden;

    public AlterTableRename(Session session, Schema schema) {
        super(session, schema);
    }

    public void setIfTableExists(boolean bl) {
        this.ifTableExists = bl;
    }

    public void setOldTableName(String string2) {
        this.oldTableName = string2;
    }

    public void setNewTableName(String string2) {
        this.newTableName = string2;
    }

    @Override
    public int update() {
        this.session.commit(true);
        Database database = this.session.getDatabase();
        Table table2 = this.getSchema().findTableOrView(this.session, this.oldTableName);
        if (table2 == null) {
            if (this.ifTableExists) {
                return 0;
            }
            throw DbException.get(42102, this.oldTableName);
        }
        this.session.getUser().checkRight(table2, 15);
        Table table3 = this.getSchema().findTableOrView(this.session, this.newTableName);
        if (table3 != null && this.hidden && this.newTableName.equals(table2.getName())) {
            if (!table3.isHidden()) {
                table3.setHidden(this.hidden);
                table2.setHidden(true);
                database.updateMeta(this.session, table2);
            }
            return 0;
        }
        if (table3 != null || this.newTableName.equals(table2.getName())) {
            throw DbException.get(42101, this.newTableName);
        }
        if (table2.isTemporary()) {
            throw DbException.getUnsupportedException("temp table");
        }
        database.renameSchemaObject(this.session, table2, this.newTableName);
        return 0;
    }

    @Override
    public int getType() {
        return 15;
    }

    public void setHidden(boolean bl) {
        this.hidden = bl;
    }
}

