/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import org.h2.command.ddl.SchemaCommand;
import org.h2.constraint.ConstraintActionType;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.Table;
import org.h2.table.TableType;
import org.h2.table.TableView;

public class DropView
extends SchemaCommand {
    private String viewName;
    private boolean ifExists;
    private ConstraintActionType dropAction;

    public DropView(Session session, Schema schema) {
        super(session, schema);
        this.dropAction = session.getDatabase().getSettings().dropRestrict ? ConstraintActionType.RESTRICT : ConstraintActionType.CASCADE;
    }

    public void setIfExists(boolean bl) {
        this.ifExists = bl;
    }

    public void setDropAction(ConstraintActionType constraintActionType) {
        this.dropAction = constraintActionType;
    }

    public void setViewName(String string2) {
        this.viewName = string2;
    }

    @Override
    public int update() {
        this.session.commit(true);
        Table table2 = this.getSchema().findTableOrView(this.session, this.viewName);
        if (table2 == null) {
            if (!this.ifExists) {
                throw DbException.get(90037, this.viewName);
            }
        } else {
            if (TableType.VIEW != table2.getTableType()) {
                throw DbException.get(90037, this.viewName);
            }
            this.session.getUser().checkRight(table2, 15);
            if (this.dropAction == ConstraintActionType.RESTRICT) {
                for (DbObject object2 : table2.getChildren()) {
                    if (!(object2 instanceof TableView)) continue;
                    throw DbException.get(90107, this.viewName, object2.getName());
                }
            }
            TableView tableView = (TableView)table2;
            ArrayList<Table> arrayList = new ArrayList<Table>(tableView.getTables());
            table2.lock(this.session, true, true);
            this.session.getDatabase().removeSchemaObject(this.session, table2);
            for (Table table3 : arrayList) {
                TableView tableView2;
                if (TableType.VIEW != table3.getTableType() || !(tableView2 = (TableView)table3).isTableExpression() || tableView2.getName() == null) continue;
                this.session.getDatabase().removeSchemaObject(this.session, tableView2);
            }
            this.session.getDatabase().unlockMeta(this.session);
        }
        return 0;
    }

    @Override
    public int getType() {
        return 48;
    }
}

