/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Comment;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.DbObjectBase;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.message.DbException;
import org.h2.table.Table;

public class SetComment
extends DefineCommand {
    private String schemaName;
    private String objectName;
    private boolean column;
    private String columnName;
    private int objectType;
    private Expression expr;

    public SetComment(Session session) {
        super(session);
    }

    @Override
    public int update() {
        DbObjectBase dbObjectBase;
        this.session.commit(true);
        Database database = this.session.getDatabase();
        this.session.getUser().checkAdmin();
        DbObject dbObject = null;
        int n = 50000;
        if (this.schemaName == null) {
            this.schemaName = this.session.getCurrentSchemaName();
        }
        switch (this.objectType) {
            case 11: {
                dbObject = database.getSchema(this.schemaName).getConstant(this.objectName);
                break;
            }
            case 5: {
                dbObject = database.getSchema(this.schemaName).getConstraint(this.objectName);
                break;
            }
            case 9: {
                dbObject = database.getSchema(this.schemaName).findFunction(this.objectName);
                n = 90077;
                break;
            }
            case 1: {
                dbObject = database.getSchema(this.schemaName).getIndex(this.objectName);
                break;
            }
            case 7: {
                this.schemaName = null;
                dbObject = database.findRole(this.objectName);
                n = 90070;
                break;
            }
            case 10: {
                this.schemaName = null;
                dbObject = database.findSchema(this.objectName);
                n = 90079;
                break;
            }
            case 3: {
                dbObject = database.getSchema(this.schemaName).getSequence(this.objectName);
                break;
            }
            case 0: {
                dbObject = database.getSchema(this.schemaName).getTableOrView(this.session, this.objectName);
                break;
            }
            case 4: {
                dbObject = database.getSchema(this.schemaName).findTrigger(this.objectName);
                n = 90042;
                break;
            }
            case 2: {
                this.schemaName = null;
                dbObject = database.getUser(this.objectName);
                break;
            }
            case 12: {
                this.schemaName = null;
                dbObject = database.findDomain(this.objectName);
                n = 90119;
                break;
            }
        }
        if (dbObject == null) {
            throw DbException.get(n, this.objectName);
        }
        String string2 = this.expr.optimize(this.session).getValue(this.session).getString();
        if (this.column) {
            dbObjectBase = (Table)dbObject;
            ((Table)dbObjectBase).getColumn(this.columnName).setComment(string2);
        } else {
            dbObject.setComment(string2);
        }
        if (this.column || this.objectType == 0 || this.objectType == 2 || this.objectType == 1 || this.objectType == 5) {
            database.updateMeta(this.session, dbObject);
        } else {
            dbObjectBase = database.findComment(dbObject);
            if (dbObjectBase == null) {
                if (string2 != null) {
                    int n2 = this.getObjectId();
                    dbObjectBase = new Comment(database, n2, dbObject);
                    ((Comment)dbObjectBase).setCommentText(string2);
                    database.addDatabaseObject(this.session, dbObjectBase);
                }
            } else if (string2 == null) {
                database.removeDatabaseObject(this.session, dbObjectBase);
            } else {
                ((Comment)dbObjectBase).setCommentText(string2);
                database.updateMeta(this.session, dbObjectBase);
            }
        }
        return 0;
    }

    public void setCommentExpression(Expression expression) {
        this.expr = expression;
    }

    public void setObjectName(String string2) {
        this.objectName = string2;
    }

    public void setObjectType(int n) {
        this.objectType = n;
    }

    public void setColumnName(String string2) {
        this.columnName = string2;
    }

    public void setSchemaName(String string2) {
        this.schemaName = string2;
    }

    public void setColumn(boolean bl) {
        this.column = bl;
    }

    @Override
    public int getType() {
        return 52;
    }
}

