/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.h2.command.Prepared;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.message.DbException;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.db.MVTableEngine;
import org.h2.result.ResultInterface;
import org.h2.store.FileLister;
import org.h2.store.PageStore;
import org.h2.store.fs.FileUtils;
import org.h2.util.IOUtils;

public class BackupCommand
extends Prepared {
    private Expression fileNameExpr;

    public BackupCommand(Session session) {
        super(session);
    }

    public void setFileName(Expression expression) {
        this.fileNameExpr = expression;
    }

    @Override
    public int update() {
        String string2 = this.fileNameExpr.getValue(this.session).getString();
        this.session.getUser().checkAdmin();
        this.backupTo(string2);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backupTo(String string2) {
        Database database = this.session.getDatabase();
        if (!database.isPersistent()) {
            throw DbException.get(90126);
        }
        try {
            MVTableEngine.Store store = database.getStore();
            if (store != null) {
                store.flush();
            }
            String string3 = database.getName();
            string3 = FileUtils.getName(string3);
            try (OutputStream outputStream2 = FileUtils.newOutputStream(string2, false);){
                String string4;
                ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream2);
                database.flush();
                if (database.getPageStore() != null) {
                    string4 = database.getName() + ".h2.db";
                    this.backupPageStore(zipOutputStream, string4, database.getPageStore());
                }
                string4 = FileUtils.getParent(database.getName());
                Object object = database.getLobSyncObject();
                synchronized (object) {
                    String string5 = database.getDatabasePath();
                    String string6 = FileUtils.getParent(string5);
                    string6 = FileLister.getDir(string6);
                    ArrayList<String> arrayList = FileLister.getDatabaseFiles(string6, string3, true);
                    for (String string7 : arrayList) {
                        if (string7.endsWith(".lob.db")) {
                            BackupCommand.backupFile(zipOutputStream, string4, string7);
                        }
                        if (!string7.endsWith(".mv.db") || store == null) continue;
                        MVStore mVStore = store.getMvStore();
                        boolean bl = mVStore.getReuseSpace();
                        mVStore.setReuseSpace(false);
                        try {
                            InputStream inputStream2 = store.getInputStream();
                            BackupCommand.backupFile(zipOutputStream, string4, string7, inputStream2);
                        }
                        finally {
                            mVStore.setReuseSpace(bl);
                        }
                    }
                }
                zipOutputStream.close();
            }
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backupPageStore(ZipOutputStream zipOutputStream, String string2, PageStore pageStore) throws IOException {
        Database database = this.session.getDatabase();
        string2 = FileUtils.getName(string2);
        zipOutputStream.putNextEntry(new ZipEntry(string2));
        int n = 0;
        try {
            pageStore.setBackup(true);
            while ((n = pageStore.copyDirect(n, zipOutputStream)) >= 0) {
                int n2 = pageStore.getPageCount();
                database.setProgress(3, string2, n, n2);
            }
        }
        finally {
            pageStore.setBackup(false);
        }
        zipOutputStream.closeEntry();
    }

    private static void backupFile(ZipOutputStream zipOutputStream, String string2, String string3) throws IOException {
        InputStream inputStream2 = FileUtils.newInputStream(string3);
        BackupCommand.backupFile(zipOutputStream, string2, string3, inputStream2);
    }

    private static void backupFile(ZipOutputStream zipOutputStream, String string2, String string3, InputStream inputStream2) throws IOException {
        String string4 = FileUtils.toRealPath(string3);
        if (!string4.startsWith(string2 = FileUtils.toRealPath(string2))) {
            DbException.throwInternalError(string4 + " does not start with " + string2);
        }
        string4 = string4.substring(string2.length());
        string4 = BackupCommand.correctFileName(string4);
        zipOutputStream.putNextEntry(new ZipEntry(string4));
        IOUtils.copyAndCloseInput(inputStream2, zipOutputStream);
        zipOutputStream.closeEntry();
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    public static String correctFileName(String string2) {
        if ((string2 = string2.replace('\\', '/')).startsWith("/")) {
            string2 = string2.substring(1);
        }
        return string2;
    }

    @Override
    public boolean needRecompile() {
        return false;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    @Override
    public int getType() {
        return 56;
    }
}

