/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.h2.message.DbException;
import org.h2.mvstore.MVStore;
import org.h2.security.SHA256;
import org.h2.store.FileLister;
import org.h2.store.FileStore;
import org.h2.store.fs.FileChannelInputStream;
import org.h2.store.fs.FileChannelOutputStream;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.FilePathEncrypt;
import org.h2.store.fs.FileUtils;
import org.h2.util.Tool;

public class ChangeFileEncryption
extends Tool {
    private String directory;
    private String cipherType;
    private byte[] decrypt;
    private byte[] encrypt;
    private byte[] decryptKey;
    private byte[] encryptKey;

    public static void main(String ... stringArray) {
        try {
            new ChangeFileEncryption().runTool(stringArray);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(System.err);
            System.exit(1);
        }
    }

    @Override
    public void runTool(String ... stringArray) throws SQLException {
        String string2 = ".";
        String string3 = null;
        char[] cArray = null;
        char[] cArray2 = null;
        String string4 = null;
        boolean bl = false;
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            String string5 = stringArray[i];
            if (string5.equals("-dir")) {
                string2 = stringArray[++i];
                continue;
            }
            if (string5.equals("-cipher")) {
                string3 = stringArray[++i];
                continue;
            }
            if (string5.equals("-db")) {
                string4 = stringArray[++i];
                continue;
            }
            if (string5.equals("-decrypt")) {
                cArray = stringArray[++i].toCharArray();
                continue;
            }
            if (string5.equals("-encrypt")) {
                cArray2 = stringArray[++i].toCharArray();
                continue;
            }
            if (string5.equals("-quiet")) {
                bl = true;
                continue;
            }
            if (string5.equals("-help") || string5.equals("-?")) {
                this.showUsage();
                return;
            }
            this.showUsageAndThrowUnsupportedOption(string5);
        }
        if (cArray2 == null && cArray == null || string3 == null) {
            this.showUsage();
            throw new SQLException("Encryption or decryption password not set, or cipher not set");
        }
        try {
            this.process(string2, string4, string3, cArray, cArray2, bl);
        }
        catch (Exception exception) {
            throw DbException.toSQLException(exception);
        }
    }

    private static byte[] getFileEncryptionKey(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        return SHA256.getKeyPasswordHash("file", (char[])cArray.clone());
    }

    public static void execute(String string2, String string3, String string4, char[] cArray, char[] cArray2, boolean bl) throws SQLException {
        try {
            new ChangeFileEncryption().process(string2, string3, string4, cArray, cArray2, bl);
        }
        catch (Exception exception) {
            throw DbException.toSQLException(exception);
        }
    }

    private void process(String string2, String string3, String string4, char[] cArray, char[] cArray2, boolean bl) throws SQLException {
        string2 = FileLister.getDir(string2);
        ChangeFileEncryption changeFileEncryption = new ChangeFileEncryption();
        if (cArray2 != null) {
            for (char c : cArray2) {
                if (c != ' ') continue;
                throw new SQLException("The file password may not contain spaces");
            }
            changeFileEncryption.encryptKey = FilePathEncrypt.getPasswordBytes(cArray2);
            changeFileEncryption.encrypt = ChangeFileEncryption.getFileEncryptionKey(cArray2);
        }
        if (cArray != null) {
            changeFileEncryption.decryptKey = FilePathEncrypt.getPasswordBytes(cArray);
            changeFileEncryption.decrypt = ChangeFileEncryption.getFileEncryptionKey(cArray);
        }
        changeFileEncryption.out = this.out;
        changeFileEncryption.directory = string2;
        changeFileEncryption.cipherType = string4;
        Object object = FileLister.getDatabaseFiles(string2, string3, true);
        FileLister.tryUnlockDatabase((List<String>)object, "encryption");
        object = FileLister.getDatabaseFiles(string2, string3, false);
        if (((ArrayList)object).isEmpty() && !bl) {
            this.printNoDatabaseFilesFound(string2, string3);
        }
        Iterator iterator2 = ((ArrayList)object).iterator();
        while (iterator2.hasNext()) {
            String string5 = (String)iterator2.next();
            String string6 = string2 + "/temp.db";
            FileUtils.delete(string6);
            FileUtils.move(string5, string6);
            FileUtils.move(string6, string5);
        }
        iterator2 = ((ArrayList)object).iterator();
        while (iterator2.hasNext()) {
            String string7 = (String)iterator2.next();
            if (FileUtils.isDirectory(string7)) continue;
            changeFileEncryption.process(string7, bl, cArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(String string2, boolean bl, char[] cArray) throws SQLException {
        if (string2.endsWith(".mv.db")) {
            try {
                this.copyMvStore(string2, bl, cArray);
            }
            catch (IOException iOException) {
                throw DbException.convertIOException(iOException, "Error encrypting / decrypting file " + string2);
            }
            return;
        }
        FileStore fileStore = this.decrypt == null ? FileStore.open(null, string2, "r") : FileStore.open(null, string2, "r", this.cipherType, this.decrypt);
        try {
            fileStore.init();
            this.copyPageStore(string2, fileStore, this.encrypt, bl);
        }
        finally {
            fileStore.closeSilently();
        }
    }

    private void copyMvStore(String string2, boolean bl, char[] cArray) throws IOException, SQLException {
        Object object;
        if (FileUtils.isDirectory(string2)) {
            return;
        }
        try {
            object = new MVStore.Builder().fileName(string2).readOnly().encryptionKey(cArray).open();
            ((MVStore)object).close();
        }
        catch (IllegalStateException illegalStateException) {
            throw new SQLException("error decrypting file " + string2, illegalStateException);
        }
        object = this.directory + "/temp.db";
        try (FileChannel fileChannel = ChangeFileEncryption.getFileChannel(string2, "r", this.decryptKey);
             FileChannelInputStream fileChannelInputStream = new FileChannelInputStream(fileChannel, true);){
            FileUtils.delete((String)object);
            try (FileChannelOutputStream fileChannelOutputStream = new FileChannelOutputStream(ChangeFileEncryption.getFileChannel((String)object, "rw", this.encryptKey), true);){
                long l;
                byte[] byArray = new byte[4096];
                long l2 = l = fileChannel.size();
                long l3 = System.nanoTime();
                while (l > 0L) {
                    if (!bl && System.nanoTime() - l3 > TimeUnit.SECONDS.toNanos(1L)) {
                        this.out.println(string2 + ": " + (100L - 100L * l / l2) + "%");
                        l3 = System.nanoTime();
                    }
                    int n = (int)Math.min((long)byArray.length, l);
                    n = ((InputStream)fileChannelInputStream).read(byArray, 0, n);
                    ((OutputStream)fileChannelOutputStream).write(byArray, 0, n);
                    l -= (long)n;
                }
            }
        }
        FileUtils.delete(string2);
        FileUtils.move((String)object, string2);
    }

    private static FileChannel getFileChannel(String string2, String string3, byte[] byArray) throws IOException {
        FileChannel fileChannel = FilePath.get(string2).open(string3);
        if (byArray != null) {
            fileChannel = new FilePathEncrypt.FileEncrypt(string2, byArray, fileChannel);
        }
        return fileChannel;
    }

    private void copyPageStore(String string2, FileStore fileStore, byte[] byArray, boolean bl) {
        long l;
        if (FileUtils.isDirectory(string2)) {
            return;
        }
        String string3 = this.directory + "/temp.db";
        FileUtils.delete(string3);
        FileStore fileStore2 = byArray == null ? FileStore.open(null, string3, "rw") : FileStore.open(null, string3, "rw", this.cipherType, byArray);
        byte[] byArray2 = new byte[4096];
        fileStore2.init();
        long l2 = l = fileStore.length() - 48L;
        fileStore.seek(48L);
        fileStore2.seek(48L);
        long l3 = System.nanoTime();
        while (l > 0L) {
            if (!bl && System.nanoTime() - l3 > TimeUnit.SECONDS.toNanos(1L)) {
                this.out.println(string2 + ": " + (100L - 100L * l / l2) + "%");
                l3 = System.nanoTime();
            }
            int n = (int)Math.min((long)byArray2.length, l);
            fileStore.readFully(byArray2, 0, n);
            fileStore2.write(byArray2, 0, n);
            l -= (long)n;
        }
        fileStore.close();
        fileStore2.close();
        FileUtils.delete(string2);
        FileUtils.move(string3, string2);
    }
}

