/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.store.fs.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.Tool;

public class Restore
extends Tool {
    public static void main(String ... stringArray) throws SQLException {
        new Restore().runTool(stringArray);
    }

    @Override
    public void runTool(String ... stringArray) throws SQLException {
        String string2 = "backup.zip";
        String string3 = ".";
        String string4 = null;
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            String string5 = stringArray[i];
            if (string5.equals("-dir")) {
                string3 = stringArray[++i];
                continue;
            }
            if (string5.equals("-file")) {
                string2 = stringArray[++i];
                continue;
            }
            if (string5.equals("-db")) {
                string4 = stringArray[++i];
                continue;
            }
            if (string5.equals("-quiet")) continue;
            if (string5.equals("-help") || string5.equals("-?")) {
                this.showUsage();
                return;
            }
            this.showUsageAndThrowUnsupportedOption(string5);
        }
        Restore.execute(string2, string3, string4);
    }

    private static String getOriginalDbName(String string2, String string3) throws IOException {
        try (InputStream inputStream2 = FileUtils.newInputStream(string2);){
            ZipEntry zipEntry;
            ZipInputStream zipInputStream = new ZipInputStream(inputStream2);
            String string4 = null;
            boolean bl = false;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string5 = zipEntry.getName();
                zipInputStream.closeEntry();
                String string6 = Restore.getDatabaseNameFromFileName(string5);
                if (string6 == null) continue;
                if (string3.equals(string6)) {
                    string4 = string6;
                    break;
                }
                if (string4 == null) {
                    string4 = string6;
                    continue;
                }
                bl = true;
            }
            zipInputStream.close();
            if (bl && !string3.equals(string4)) {
                throw new IOException("Multiple databases found, but not " + string3);
            }
            zipEntry = string4;
            return zipEntry;
        }
    }

    private static String getDatabaseNameFromFileName(String string2) {
        if (string2.endsWith(".h2.db")) {
            return string2.substring(0, string2.length() - ".h2.db".length());
        }
        if (string2.endsWith(".mv.db")) {
            return string2.substring(0, string2.length() - ".mv.db".length());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(String string2, String string3, String string4) {
        InputStream inputStream2 = null;
        try {
            if (!FileUtils.exists(string2)) {
                throw new IOException("File not found: " + string2);
            }
            String string5 = null;
            int n = 0;
            if (string4 != null) {
                string5 = Restore.getOriginalDbName(string2, string4);
                if (string5 == null) {
                    throw new IOException("No database named " + string4 + " found");
                }
                if (string5.startsWith(SysProperties.FILE_SEPARATOR)) {
                    string5 = string5.substring(1);
                }
                n = string5.length();
            }
            inputStream2 = FileUtils.newInputStream(string2);
            try (ZipInputStream zipInputStream = new ZipInputStream(inputStream2);){
                ZipEntry zipEntry;
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    String string6 = zipEntry.getName();
                    string6 = string6.replace('\\', SysProperties.FILE_SEPARATOR.charAt(0));
                    if ((string6 = string6.replace('/', SysProperties.FILE_SEPARATOR.charAt(0))).startsWith(SysProperties.FILE_SEPARATOR)) {
                        string6 = string6.substring(1);
                    }
                    boolean bl = false;
                    if (string4 == null) {
                        bl = true;
                    } else if (string6.startsWith(string5 + ".")) {
                        string6 = string4 + string6.substring(n);
                        bl = true;
                    }
                    if (bl) {
                        OutputStream outputStream2 = null;
                        try {
                            outputStream2 = FileUtils.newOutputStream(string3 + SysProperties.FILE_SEPARATOR + string6, false);
                            IOUtils.copy(zipInputStream, outputStream2);
                            outputStream2.close();
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeSilently(outputStream2);
                            throw throwable;
                        }
                        IOUtils.closeSilently(outputStream2);
                    }
                    zipInputStream.closeEntry();
                }
                zipInputStream.closeEntry();
            }
        }
        catch (IOException iOException) {
            try {
                throw DbException.convertIOException(iOException, string2);
            }
            catch (Throwable throwable) {
                IOUtils.closeSilently(inputStream2);
                throw throwable;
            }
        }
        IOUtils.closeSilently(inputStream2);
    }
}

