/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.lang.reflect.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import org.h2.engine.SysProperties;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueCollectionBase;

public class ValueArray
extends ValueCollectionBase {
    private static final Object EMPTY = ValueArray.get(new Value[0]);
    private final Class<?> componentType;

    private ValueArray(Class<?> clazz, Value[] valueArray) {
        super(valueArray);
        this.componentType = clazz;
    }

    public static ValueArray get(Value[] valueArray) {
        return new ValueArray(Object.class, valueArray);
    }

    public static ValueArray get(Class<?> clazz, Value[] valueArray) {
        return new ValueArray(clazz, valueArray);
    }

    public static ValueArray getEmpty() {
        return (ValueArray)EMPTY;
    }

    @Override
    public int getValueType() {
        return 17;
    }

    public Class<?> getComponentType() {
        return this.componentType;
    }

    @Override
    public String getString() {
        StringBuilder stringBuilder = new StringBuilder().append('[');
        for (int i = 0; i < this.values.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.values[i].getString());
        }
        return stringBuilder.append(']').toString();
    }

    @Override
    public int compareTypeSafe(Value value2, CompareMode compareMode) {
        ValueArray valueArray = (ValueArray)value2;
        if (this.values == valueArray.values) {
            return 0;
        }
        int n = this.values.length;
        int n2 = valueArray.values.length;
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            Value value3 = this.values[i];
            Value value4 = valueArray.values[i];
            int n4 = value3.compareTo(value4, null, compareMode);
            if (n4 == 0) continue;
            return n4;
        }
        return Integer.compare(n, n2);
    }

    @Override
    public Object getObject() {
        int n = this.values.length;
        Object[] objectArray = (Object[])Array.newInstance(this.componentType, n);
        for (int i = 0; i < n; ++i) {
            int n2;
            Value value2 = this.values[i];
            objectArray[i] = !SysProperties.OLD_RESULT_SET_GET_OBJECT && ((n2 = value2.getValueType()) == 2 || n2 == 3) ? Integer.valueOf(value2.getInt()) : value2.getObject();
        }
        return objectArray;
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setArray(n, preparedStatement.getConnection().createArrayOf("NULL", (Object[])this.getObject()));
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder) {
        stringBuilder.append("ARRAY [");
        int n = this.values.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            this.values[i].getSQL(stringBuilder);
        }
        return stringBuilder.append(']');
    }

    @Override
    public String getTraceSQL() {
        StringBuilder stringBuilder = new StringBuilder("[");
        for (int i = 0; i < this.values.length; ++i) {
            Value value2;
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append((value2 = this.values[i]) == null ? "null" : value2.getTraceSQL());
        }
        return stringBuilder.append(']').toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ValueArray)) {
            return false;
        }
        ValueArray valueArray = (ValueArray)object;
        if (this.values == valueArray.values) {
            return true;
        }
        int n = this.values.length;
        if (n != valueArray.values.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.values[i].equals(valueArray.values[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public Value convertPrecision(long l, boolean bl) {
        int n;
        if (!bl) {
            return this;
        }
        int n2 = this.values.length;
        Value[] valueArray = new Value[n2];
        boolean bl2 = false;
        for (n = 0; n < n2; ++n) {
            Value value2 = this.values[n];
            Value value3 = value2.convertPrecision(l, true);
            if (value3 != value2) {
                bl2 = true;
            }
            if ((l -= Math.max(1L, value3.getType().getPrecision())) < 0L) break;
            valueArray[n] = value3;
        }
        if (n < n2) {
            return ValueArray.get(this.componentType, Arrays.copyOf(valueArray, n));
        }
        return bl2 ? ValueArray.get(this.componentType, valueArray) : this;
    }
}

