/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.message.DbException;
import org.h2.value.CompareMode;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

public class ValueLong
extends Value {
    public static final ValueLong MIN = ValueLong.get(Long.MIN_VALUE);
    public static final ValueLong MAX = ValueLong.get(Long.MAX_VALUE);
    public static final BigInteger MAX_BI = BigInteger.valueOf(Long.MAX_VALUE);
    public static final int PRECISION = 19;
    public static final int DISPLAY_SIZE = 20;
    private static final int STATIC_SIZE = 100;
    private static final ValueLong[] STATIC_CACHE = new ValueLong[100];
    private final long value;

    private ValueLong(long l) {
        this.value = l;
    }

    @Override
    public Value add(Value value2) {
        long l = this.value;
        long l2 = ((ValueLong)value2).value;
        long l3 = l + l2;
        if (((l ^ l3) & (l2 ^ l3)) < 0L) {
            throw this.getOverflow();
        }
        return ValueLong.get(l3);
    }

    @Override
    public int getSignum() {
        return Long.signum(this.value);
    }

    @Override
    public Value negate() {
        if (this.value == Long.MIN_VALUE) {
            throw this.getOverflow();
        }
        return ValueLong.get(-this.value);
    }

    private DbException getOverflow() {
        return DbException.get(22003, Long.toString(this.value));
    }

    @Override
    public Value subtract(Value value2) {
        long l = this.value;
        long l2 = ((ValueLong)value2).value;
        long l3 = l - l2;
        if (((l ^ l2) & (l ^ l3)) < 0L) {
            throw this.getOverflow();
        }
        return ValueLong.get(l3);
    }

    @Override
    public Value multiply(Value value2) {
        long l = this.value;
        long l2 = ((ValueLong)value2).value;
        long l3 = l * l2;
        if ((Math.abs(l) | Math.abs(l2)) >>> 31 != 0L && l2 != 0L && (l3 / l2 != l || l == Long.MIN_VALUE && l2 == -1L)) {
            throw this.getOverflow();
        }
        return ValueLong.get(l3);
    }

    @Override
    public Value divide(Value value2) {
        long l = ((ValueLong)value2).value;
        if (l == 0L) {
            throw DbException.get(22012, this.getSQL());
        }
        long l2 = this.value;
        if (l2 == Long.MIN_VALUE && l == -1L) {
            throw this.getOverflow();
        }
        return ValueLong.get(l2 / l);
    }

    @Override
    public Value modulus(Value value2) {
        ValueLong valueLong = (ValueLong)value2;
        if (valueLong.value == 0L) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueLong.get(this.value % valueLong.value);
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder) {
        return stringBuilder.append(this.value);
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_LONG;
    }

    @Override
    public int getValueType() {
        return 5;
    }

    @Override
    public long getLong() {
        return this.value;
    }

    @Override
    public int compareTypeSafe(Value value2, CompareMode compareMode) {
        return Long.compare(this.value, ((ValueLong)value2).value);
    }

    @Override
    public String getString() {
        return Long.toString(this.value);
    }

    @Override
    public int hashCode() {
        return (int)(this.value ^ this.value >> 32);
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setLong(n, this.value);
    }

    public static ValueLong get(long l) {
        if (l >= 0L && l < 100L) {
            return STATIC_CACHE[(int)l];
        }
        return (ValueLong)Value.cache(new ValueLong(l));
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ValueLong && this.value == ((ValueLong)object).value;
    }

    static {
        for (int i = 0; i < 100; ++i) {
            ValueLong.STATIC_CACHE[i] = new ValueLong(i);
        }
    }
}

