/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.internal;

import java.util.Iterator;
import java.util.Map;
import zipkin2.Annotation;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.internal.JsonEscaper;
import zipkin2.internal.Nullable;
import zipkin2.internal.WriteBuffer;

public final class V2SpanWriter
implements WriteBuffer.Writer<Span> {
    @Override
    public int sizeInBytes(Span value2) {
        int sizeInBytes = 13;
        sizeInBytes += value2.traceId().length();
        if (value2.parentId() != null) {
            sizeInBytes += 30;
        }
        sizeInBytes += 24;
        if (value2.kind() != null) {
            sizeInBytes += 10;
            sizeInBytes += value2.kind().name().length();
        }
        if (value2.name() != null) {
            sizeInBytes += 10;
            sizeInBytes += JsonEscaper.jsonEscapedSizeInBytes(value2.name());
        }
        if (value2.timestampAsLong() != 0L) {
            sizeInBytes += 13;
            sizeInBytes += WriteBuffer.asciiSizeInBytes(value2.timestampAsLong());
        }
        if (value2.durationAsLong() != 0L) {
            sizeInBytes += 12;
            sizeInBytes += WriteBuffer.asciiSizeInBytes(value2.durationAsLong());
        }
        if (value2.localEndpoint() != null) {
            sizeInBytes += 17;
            sizeInBytes += V2SpanWriter.endpointSizeInBytes(value2.localEndpoint(), false);
        }
        if (value2.remoteEndpoint() != null) {
            sizeInBytes += 18;
            sizeInBytes += V2SpanWriter.endpointSizeInBytes(value2.remoteEndpoint(), false);
        }
        if (!value2.annotations().isEmpty()) {
            sizeInBytes += 17;
            int length = value2.annotations().size();
            if (length > 1) {
                sizeInBytes += length - 1;
            }
            for (int i = 0; i < length; ++i) {
                Annotation a = value2.annotations().get(i);
                sizeInBytes += V2SpanWriter.annotationSizeInBytes(a.timestamp(), a.value(), 0);
            }
        }
        if (!value2.tags().isEmpty()) {
            sizeInBytes += 10;
            int tagCount = value2.tags().size();
            if (tagCount > 1) {
                sizeInBytes += tagCount - 1;
            }
            for (Map.Entry<String, String> entry : value2.tags().entrySet()) {
                sizeInBytes += 5;
                sizeInBytes += JsonEscaper.jsonEscapedSizeInBytes(entry.getKey());
                sizeInBytes += JsonEscaper.jsonEscapedSizeInBytes(entry.getValue());
            }
        }
        if (Boolean.TRUE.equals(value2.debug())) {
            sizeInBytes += 13;
        }
        if (Boolean.TRUE.equals(value2.shared())) {
            sizeInBytes += 14;
        }
        return ++sizeInBytes;
    }

    @Override
    public void write(Span value2, WriteBuffer b) {
        b.writeAscii("{\"traceId\":\"");
        b.writeAscii(value2.traceId());
        b.writeByte(34);
        if (value2.parentId() != null) {
            b.writeAscii(",\"parentId\":\"");
            b.writeAscii(value2.parentId());
            b.writeByte(34);
        }
        b.writeAscii(",\"id\":\"");
        b.writeAscii(value2.id());
        b.writeByte(34);
        if (value2.kind() != null) {
            b.writeAscii(",\"kind\":\"");
            b.writeAscii(value2.kind().toString());
            b.writeByte(34);
        }
        if (value2.name() != null) {
            b.writeAscii(",\"name\":\"");
            b.writeUtf8(JsonEscaper.jsonEscape(value2.name()));
            b.writeByte(34);
        }
        if (value2.timestampAsLong() != 0L) {
            b.writeAscii(",\"timestamp\":");
            b.writeAscii(value2.timestampAsLong());
        }
        if (value2.durationAsLong() != 0L) {
            b.writeAscii(",\"duration\":");
            b.writeAscii(value2.durationAsLong());
        }
        if (value2.localEndpoint() != null) {
            b.writeAscii(",\"localEndpoint\":");
            V2SpanWriter.writeEndpoint(value2.localEndpoint(), b, false);
        }
        if (value2.remoteEndpoint() != null) {
            b.writeAscii(",\"remoteEndpoint\":");
            V2SpanWriter.writeEndpoint(value2.remoteEndpoint(), b, false);
        }
        if (!value2.annotations().isEmpty()) {
            b.writeAscii(",\"annotations\":");
            b.writeByte(91);
            int i = 0;
            int length = value2.annotations().size();
            while (i < length) {
                Annotation a = value2.annotations().get(i++);
                V2SpanWriter.writeAnnotation(a.timestamp(), a.value(), null, b);
                if (i >= length) continue;
                b.writeByte(44);
            }
            b.writeByte(93);
        }
        if (!value2.tags().isEmpty()) {
            b.writeAscii(",\"tags\":{");
            Iterator<Map.Entry<String, String>> i = value2.tags().entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<String, String> entry = i.next();
                b.writeByte(34);
                b.writeUtf8(JsonEscaper.jsonEscape(entry.getKey()));
                b.writeAscii("\":\"");
                b.writeUtf8(JsonEscaper.jsonEscape(entry.getValue()));
                b.writeByte(34);
                if (!i.hasNext()) continue;
                b.writeByte(44);
            }
            b.writeByte(125);
        }
        if (Boolean.TRUE.equals(value2.debug())) {
            b.writeAscii(",\"debug\":true");
        }
        if (Boolean.TRUE.equals(value2.shared())) {
            b.writeAscii(",\"shared\":true");
        }
        b.writeByte(125);
    }

    public String toString() {
        return "Span";
    }

    static int endpointSizeInBytes(Endpoint value2, boolean writeEmptyServiceName) {
        int port;
        int sizeInBytes = 1;
        String serviceName = value2.serviceName();
        if (serviceName == null && writeEmptyServiceName) {
            serviceName = "";
        }
        if (serviceName != null) {
            sizeInBytes += 16;
            sizeInBytes += JsonEscaper.jsonEscapedSizeInBytes(serviceName);
        }
        if (value2.ipv4() != null) {
            if (sizeInBytes != 1) {
                ++sizeInBytes;
            }
            sizeInBytes += 9;
            sizeInBytes += value2.ipv4().length();
        }
        if (value2.ipv6() != null) {
            if (sizeInBytes != 1) {
                ++sizeInBytes;
            }
            sizeInBytes += 9;
            sizeInBytes += value2.ipv6().length();
        }
        if ((port = value2.portAsInt()) != 0) {
            if (sizeInBytes != 1) {
                ++sizeInBytes;
            }
            sizeInBytes += 7;
            sizeInBytes += WriteBuffer.asciiSizeInBytes(port);
        }
        return ++sizeInBytes;
    }

    static void writeEndpoint(Endpoint value2, WriteBuffer b, boolean writeEmptyServiceName) {
        int port;
        b.writeByte(123);
        boolean wroteField = false;
        String serviceName = value2.serviceName();
        if (serviceName == null && writeEmptyServiceName) {
            serviceName = "";
        }
        if (serviceName != null) {
            b.writeAscii("\"serviceName\":\"");
            b.writeUtf8(JsonEscaper.jsonEscape(serviceName));
            b.writeByte(34);
            wroteField = true;
        }
        if (value2.ipv4() != null) {
            if (wroteField) {
                b.writeByte(44);
            }
            b.writeAscii("\"ipv4\":\"");
            b.writeAscii(value2.ipv4());
            b.writeByte(34);
            wroteField = true;
        }
        if (value2.ipv6() != null) {
            if (wroteField) {
                b.writeByte(44);
            }
            b.writeAscii("\"ipv6\":\"");
            b.writeAscii(value2.ipv6());
            b.writeByte(34);
            wroteField = true;
        }
        if ((port = value2.portAsInt()) != 0) {
            if (wroteField) {
                b.writeByte(44);
            }
            b.writeAscii("\"port\":");
            b.writeAscii(port);
        }
        b.writeByte(125);
    }

    static int annotationSizeInBytes(long timestamp, String value2, int endpointSizeInBytes) {
        int sizeInBytes = 25;
        sizeInBytes += WriteBuffer.asciiSizeInBytes(timestamp);
        sizeInBytes += JsonEscaper.jsonEscapedSizeInBytes(value2);
        if (endpointSizeInBytes != 0) {
            sizeInBytes += 12;
            sizeInBytes += endpointSizeInBytes;
        }
        return sizeInBytes;
    }

    static void writeAnnotation(long timestamp, String value2, @Nullable byte[] endpoint, WriteBuffer b) {
        b.writeAscii("{\"timestamp\":");
        b.writeAscii(timestamp);
        b.writeAscii(",\"value\":\"");
        b.writeUtf8(JsonEscaper.jsonEscape(value2));
        b.writeByte(34);
        if (endpoint != null) {
            b.writeAscii(",\"endpoint\":");
            b.write(endpoint);
        }
        b.writeByte(125);
    }
}

