/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.okhttp3;

import java.io.IOException;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import zipkin2.codec.Encoding;

enum RequestBodyMessageEncoder {
    JSON{

        @Override
        public RequestBody encode(List<byte[]> encodedSpans) {
            return new JsonRequestBody(encodedSpans);
        }
    }
    ,
    THRIFT{

        @Override
        RequestBody encode(List<byte[]> encodedSpans) {
            return new ThriftRequestBody(encodedSpans);
        }
    }
    ,
    PROTO3{

        @Override
        RequestBody encode(List<byte[]> encodedSpans) {
            return new Protobuf3RequestBody(encodedSpans);
        }
    };


    abstract RequestBody encode(List<byte[]> var1);

    static final class Protobuf3RequestBody
    extends StreamingRequestBody {
        static final MediaType CONTENT_TYPE = MediaType.parse("application/x-protobuf");

        Protobuf3RequestBody(List<byte[]> values2) {
            super(Encoding.PROTO3, CONTENT_TYPE, values2);
        }

        @Override
        public void writeTo(BufferedSink sink2) throws IOException {
            int i = 0;
            int length = this.values.size();
            while (i < length) {
                byte[] next = (byte[])this.values.get(i++);
                sink2.write(next);
            }
        }
    }

    static final class ThriftRequestBody
    extends StreamingRequestBody {
        static final MediaType CONTENT_TYPE = MediaType.parse("application/x-thrift");

        ThriftRequestBody(List<byte[]> values2) {
            super(Encoding.THRIFT, CONTENT_TYPE, values2);
        }

        @Override
        public void writeTo(BufferedSink sink2) throws IOException {
            int length = this.values.size();
            sink2.writeByte(12);
            sink2.writeByte(length >>> 24 & 0xFF);
            sink2.writeByte(length >>> 16 & 0xFF);
            sink2.writeByte(length >>> 8 & 0xFF);
            sink2.writeByte(length & 0xFF);
            int i = 0;
            while (i < length) {
                byte[] next = (byte[])this.values.get(i++);
                sink2.write(next);
            }
        }
    }

    static final class JsonRequestBody
    extends StreamingRequestBody {
        static final MediaType CONTENT_TYPE = MediaType.parse("application/json");

        JsonRequestBody(List<byte[]> values2) {
            super(Encoding.JSON, CONTENT_TYPE, values2);
        }

        @Override
        public void writeTo(BufferedSink sink2) throws IOException {
            sink2.writeByte(91);
            int i = 0;
            int length = this.values.size();
            while (i < length) {
                byte[] next = (byte[])this.values.get(i++);
                sink2.write(next);
                if (i >= length) continue;
                sink2.writeByte(44);
            }
            sink2.writeByte(93);
        }
    }

    static abstract class StreamingRequestBody
    extends RequestBody {
        final MediaType contentType;
        final List<byte[]> values;
        final long contentLength;

        StreamingRequestBody(Encoding encoding, MediaType contentType, List<byte[]> values2) {
            this.contentType = contentType;
            this.values = values2;
            this.contentLength = encoding.listSizeInBytes(values2);
        }

        @Override
        public MediaType contentType() {
            return this.contentType;
        }

        @Override
        public long contentLength() {
            return this.contentLength;
        }
    }
}

