/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.observe.trace.extension.jaeger;

import io.jaegertracing.Configuration;
import io.opentracing.ScopeManager;
import io.opentracing.Tracer;
import java.io.PrintStream;
import java.util.Objects;
import org.ballerinalang.config.ConfigRegistry;
import org.ballerinalang.jvm.observability.InvalidConfigurationException;
import org.ballerinalang.jvm.observability.tracer.OpenTracer;
import org.ballerinalang.observe.trace.extension.jaeger.NoOpScopeManager;

public class OpenTracingExtension
implements OpenTracer {
    private ConfigRegistry configRegistry;
    private String hostname;
    private int port;
    private String samplerType;
    private Number samplerParam;
    private int reporterFlushInterval;
    private int reporterBufferSize;
    private static final PrintStream console = System.out;
    private static final PrintStream consoleError = System.err;

    public void init() throws InvalidConfigurationException {
        this.configRegistry = ConfigRegistry.getInstance();
        try {
            this.port = Integer.parseInt(this.configRegistry.getConfigOrDefault("b7a.observability.tracing.jaeger.reporter.port", String.valueOf(5775)));
            this.hostname = this.configRegistry.getConfigOrDefault("b7a.observability.tracing.jaeger.reporter.hostname", "localhost");
            this.samplerType = this.configRegistry.getConfigOrDefault("b7a.observability.tracing.jaeger.sampler.type", "const");
            if (!(this.samplerType.equals("const") || this.samplerType.equals("ratelimiting") || this.samplerType.equals("probabilistic"))) {
                this.samplerType = "const";
                consoleError.println("error: Jaeger configuration: \"sampler type\" invalid. Defaulted to const sampling");
            }
            this.samplerParam = Float.valueOf(this.configRegistry.getConfigOrDefault("b7a.observability.tracing.jaeger.sampler.param", String.valueOf(1)));
            this.reporterFlushInterval = Integer.parseInt(this.configRegistry.getConfigOrDefault("b7a.observability.tracing.jaeger.reporter.flush.interval.ms", String.valueOf(1000)));
            this.reporterBufferSize = Integer.parseInt(this.configRegistry.getConfigOrDefault("b7a.observability.tracing.jaeger.reporter.max.buffer.spans", String.valueOf(10000)));
        }
        catch (ArithmeticException | IllegalArgumentException e) {
            throw new InvalidConfigurationException(e.getMessage());
        }
        console.println("ballerina: started publishing tracers to Jaeger on " + this.hostname + ":" + this.port);
    }

    public Tracer getTracer(String tracerName, String serviceName) {
        if (Objects.isNull(this.configRegistry)) {
            throw new IllegalStateException("Tracer not initialized with configurations");
        }
        return new Configuration(serviceName).withSampler(new Configuration.SamplerConfiguration().withType(this.samplerType).withParam(this.samplerParam)).withReporter(new Configuration.ReporterConfiguration().withLogSpans(Boolean.FALSE).withSender(new Configuration.SenderConfiguration().withAgentHost(this.hostname).withAgentPort(Integer.valueOf(this.port))).withFlushInterval(Integer.valueOf(this.reporterFlushInterval)).withMaxQueueSize(Integer.valueOf(this.reporterBufferSize))).getTracerBuilder().withScopeManager((ScopeManager)NoOpScopeManager.INSTANCE).build();
    }

    public String getName() {
        return "jaeger";
    }
}

