/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.time.nativeimpl;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import org.ballerinalang.jvm.types.BTupleType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.TupleValueImpl;
import org.ballerinalang.stdlib.time.util.TimeUtils;

public class ExternMethods {
    private static final BTupleType getDateTupleType = new BTupleType(Arrays.asList(BTypes.typeInt, BTypes.typeInt, BTypes.typeInt));
    private static final BTupleType getTimeTupleType = new BTupleType(Arrays.asList(BTypes.typeInt, BTypes.typeInt, BTypes.typeInt, BTypes.typeInt));

    private ExternMethods() {
    }

    public static String toString(MapValue<String, Object> timeRecord) {
        return TimeUtils.getDefaultString(timeRecord);
    }

    public static Object format(MapValue<String, Object> timeRecord, Object pattern) {
        try {
            if ("RFC_1123".equals(pattern.toString())) {
                ZonedDateTime zonedDateTime = TimeUtils.getZonedDateTime(timeRecord);
                return zonedDateTime.format(DateTimeFormatter.RFC_1123_DATE_TIME);
            }
            return TimeUtils.getFormattedString(timeRecord, pattern.toString());
        }
        catch (IllegalArgumentException e) {
            return TimeUtils.getTimeError("Invalid Pattern: " + pattern.toString());
        }
    }

    public static long getYear(MapValue<String, Object> timeRecord) {
        ZonedDateTime dateTime = TimeUtils.getZonedDateTime(timeRecord);
        return dateTime.getYear();
    }

    public static long getMonth(MapValue<String, Object> timeRecord) {
        ZonedDateTime dateTime = TimeUtils.getZonedDateTime(timeRecord);
        return dateTime.getMonthValue();
    }

    public static long getDay(MapValue<String, Object> timeRecord) {
        ZonedDateTime dateTime = TimeUtils.getZonedDateTime(timeRecord);
        return dateTime.getDayOfMonth();
    }

    public static String getWeekday(MapValue<String, Object> timeRecord) {
        ZonedDateTime dateTime = TimeUtils.getZonedDateTime(timeRecord);
        return dateTime.getDayOfWeek().toString();
    }

    public static long getHour(MapValue<String, Object> timeRecord) {
        ZonedDateTime dateTime = TimeUtils.getZonedDateTime(timeRecord);
        return dateTime.getHour();
    }

    public static long getMinute(MapValue<String, Object> timeRecord) {
        ZonedDateTime dateTime = TimeUtils.getZonedDateTime(timeRecord);
        return dateTime.getMinute();
    }

    public static long getSecond(MapValue<String, Object> timeRecord) {
        ZonedDateTime dateTime = TimeUtils.getZonedDateTime(timeRecord);
        return dateTime.getSecond();
    }

    public static long getMilliSecond(MapValue<String, Object> timeRecord) {
        ZonedDateTime dateTime = TimeUtils.getZonedDateTime(timeRecord);
        return dateTime.getNano() / 1000000;
    }

    public static ArrayValue getDate(MapValue<String, Object> timeRecord) {
        TupleValueImpl date = new TupleValueImpl(getDateTupleType);
        date.add(0L, (Object)ExternMethods.getYear(timeRecord));
        date.add(1L, (Object)ExternMethods.getMonth(timeRecord));
        date.add(2L, (Object)ExternMethods.getDay(timeRecord));
        return date;
    }

    public static ArrayValue getTime(MapValue<String, Object> timeRecord) {
        TupleValueImpl time = new TupleValueImpl(getTimeTupleType);
        time.add(0L, (Object)ExternMethods.getHour(timeRecord));
        time.add(1L, (Object)ExternMethods.getMinute(timeRecord));
        time.add(2L, (Object)ExternMethods.getSecond(timeRecord));
        time.add(3L, (Object)ExternMethods.getMilliSecond(timeRecord));
        return time;
    }

    public static MapValue<?, ?> addDuration(MapValue<String, Object> timeRecord, long years, long months, long days, long hours, long minutes, long seconds, long milliSeconds) {
        ZonedDateTime dateTime = TimeUtils.getZonedDateTime(timeRecord);
        long nanoSeconds = milliSeconds * 1000000L;
        dateTime = dateTime.plusYears(years).plusMonths(months).plusDays(days).plusHours(hours).plusMinutes(minutes).plusSeconds(seconds).plusNanos(nanoSeconds);
        long mSec = dateTime.toInstant().toEpochMilli();
        return TimeUtils.createTimeRecord(TimeUtils.getTimeZoneRecord(), TimeUtils.getTimeRecord(), mSec, TimeUtils.getZoneId(timeRecord));
    }

    public static MapValue<String, Object> subtractDuration(MapValue<String, Object> timeRecord, long years, long months, long days, long hours, long minutes, long seconds, long milliSeconds) {
        ZonedDateTime dateTime = TimeUtils.getZonedDateTime(timeRecord);
        long nanoSeconds = milliSeconds * 1000000L;
        dateTime = dateTime.minusYears(years).minusMonths(months).minusDays(days).minusHours(hours).minusMinutes(minutes).minusSeconds(seconds).minusNanos(nanoSeconds);
        long mSec = dateTime.toInstant().toEpochMilli();
        return TimeUtils.createTimeRecord(TimeUtils.getTimeZoneRecord(), TimeUtils.getTimeRecord(), mSec, TimeUtils.getZoneId(timeRecord));
    }

    public static Object toTimeZone(MapValue<String, Object> timeRecord, String zoneId) {
        try {
            return TimeUtils.changeTimezone(timeRecord, zoneId);
        }
        catch (ErrorValue e) {
            return e;
        }
    }

    public static MapValue<?, ?> currentTime() {
        long currentTime = Instant.now().toEpochMilli();
        return TimeUtils.createTimeRecord(TimeUtils.getTimeZoneRecord(), TimeUtils.getTimeRecord(), currentTime, ZoneId.systemDefault().toString());
    }

    public static Object createTime(long years, long months, long dates, long hours, long minutes, long seconds, long milliSeconds, String zoneId) {
        try {
            return TimeUtils.createDateTime((int)years, (int)months, (int)dates, (int)hours, (int)minutes, (int)seconds, (int)milliSeconds, zoneId);
        }
        catch (ErrorValue e) {
            return e;
        }
    }

    public static Object parse(String dateString, Object pattern) {
        try {
            if ("RFC_1123".equals(pattern.toString())) {
                TemporalAccessor parsedDateTime = DateTimeFormatter.RFC_1123_DATE_TIME.parse(dateString);
                return TimeUtils.getTimeRecord(parsedDateTime, dateString, pattern.toString());
            }
            return TimeUtils.parseTime(dateString, pattern.toString());
        }
        catch (ErrorValue e) {
            return e;
        }
    }
}

