/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.observe.nativeimpl;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.observability.metrics.Counter;
import org.ballerinalang.jvm.observability.metrics.DefaultMetricRegistry;
import org.ballerinalang.jvm.observability.metrics.Gauge;
import org.ballerinalang.jvm.observability.metrics.Metric;
import org.ballerinalang.jvm.observability.metrics.MetricId;
import org.ballerinalang.jvm.observability.metrics.PolledGauge;
import org.ballerinalang.jvm.observability.metrics.Tag;
import org.ballerinalang.jvm.observability.metrics.Tags;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.types.BMapType;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.MapValueImpl;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.observe.nativeimpl.ObserveNativeImplConstants;
import org.ballerinalang.observe.nativeimpl.Utils;

@BallerinaFunction(orgName="ballerina", packageName="observe", functionName="lookupMetric", returnType={@ReturnType(type=TypeKind.ARRAY)}, isPublic=true)
public class LookupMetric {
    public static Object lookupMetric(Strand strand, String metricName, Object tags) {
        Map<String, String> tagMap = Utils.toStringMap((MapValue)tags);
        HashSet tagSet = new HashSet();
        Tags.tags(tagSet, tagMap);
        Metric metric = DefaultMetricRegistry.getInstance().lookup(new MetricId(metricName, "", tagSet));
        if (metric != null) {
            MetricId metricId = metric.getId();
            if (metric instanceof Counter) {
                ObjectValue counter = BallerinaValues.createObjectValue((BPackage)ObserveNativeImplConstants.OBSERVE_PACKAGE_ID, (String)"Counter", (Object[])new Object[]{metricId.getName(), metricId.getDescription(), LookupMetric.getTags(metricId)});
                counter.addNativeData("__metric_native_instance__", (Object)metric);
                return counter;
            }
            if (metric instanceof Gauge) {
                Gauge gauge = (Gauge)metric;
                ArrayValue statisticConfigs = Utils.createBStatisticConfig(gauge.getStatisticsConfig());
                ObjectValue bGauge = BallerinaValues.createObjectValue((BPackage)ObserveNativeImplConstants.OBSERVE_PACKAGE_ID, (String)"Gauge", (Object[])new Object[]{metricId.getName(), metricId.getDescription(), LookupMetric.getTags(metricId), statisticConfigs});
                bGauge.addNativeData("__metric_native_instance__", (Object)metric);
                return bGauge;
            }
            if (metric instanceof PolledGauge) {
                ArrayValue statisticConfigs = Utils.createBStatisticConfig(null);
                ObjectValue bGauge = BallerinaValues.createObjectValue((BPackage)ObserveNativeImplConstants.OBSERVE_PACKAGE_ID, (String)"Gauge", (Object[])new Object[]{metricId.getName(), metricId.getDescription(), LookupMetric.getTags(metricId), statisticConfigs});
                bGauge.addNativeData("__metric_native_instance__", (Object)metric);
                return bGauge;
            }
        }
        return null;
    }

    private static MapValue<String, Object> getTags(MetricId metricId) {
        MapValueImpl bTags = new MapValueImpl((BType)new BMapType(BTypes.typeString));
        Set tags = metricId.getTags();
        for (Tag tag : tags) {
            bTags.put((Object)tag.getKey(), (Object)tag.getValue());
        }
        return bTags;
    }
}

