/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.cache.nativeimpl.concurrentlinkedhashmap;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.ballerinalang.stdlib.cache.nativeimpl.concurrentlinkedhashmap.Linked;
import org.ballerinalang.stdlib.cache.nativeimpl.concurrentlinkedhashmap.LinkedDeque;
import org.ballerinalang.stdlib.cache.nativeimpl.concurrentlinkedhashmap.Weigher;
import org.ballerinalang.stdlib.cache.nativeimpl.concurrentlinkedhashmap.Weighers;

public class ConcurrentLinkedHashMap<K, V>
implements ConcurrentMap<K, V>,
Serializable {
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MAXIMUM_BUFFER_SIZE = 0x100000;
    static final int BUFFER_THRESHOLD = 16;
    static final int NUMBER_OF_BUFFERS;
    static final int BUFFER_MASK;
    static final int AMORTIZED_DRAIN_THRESHOLD;
    final ConcurrentHashMap<K, Node> data;
    int concurrencyLevel = 16;
    transient LinkedDeque<Node> evictionDeque;
    volatile int weightedSize;
    volatile int capacity;
    volatile int nextOrder;
    int drainedOrder;
    final transient Lock evictionLock;
    final Queue<Task>[] buffers;
    transient ExecutorService executor = new DisabledExecutorService();
    final Weigher<? super V> weigher;
    final AtomicIntegerArray bufferLengths;
    final AtomicReference<DrainStatus> drainStatus;
    transient Set<K> keySet;
    transient Set<Map.Entry<K, V>> entrySet;
    private static final long serialVersionUID = 1L;

    static int ceilingNextPowerOfTwo(int x) {
        return 1 << 32 - Integer.numberOfLeadingZeros(x - 1);
    }

    public ConcurrentLinkedHashMap(int maximumCapacity) {
        this.capacity = maximumCapacity;
        this.data = new ConcurrentHashMap(3, 0.75f, 16);
        this.weigher = Weighers.singleton();
        this.nextOrder = Integer.MIN_VALUE;
        this.drainedOrder = Integer.MIN_VALUE;
        this.evictionLock = new ReentrantLock();
        this.evictionDeque = new LinkedDeque();
        this.drainStatus = new AtomicReference<DrainStatus>(DrainStatus.IDLE);
        this.buffers = new Queue[NUMBER_OF_BUFFERS];
        this.bufferLengths = new AtomicIntegerArray(NUMBER_OF_BUFFERS);
        for (int i = 0; i < NUMBER_OF_BUFFERS; ++i) {
            this.buffers[i] = new ConcurrentLinkedQueue<Task>();
        }
    }

    public void setCapacity(int capacity) {
        this.evictionLock.lock();
        try {
            this.capacity = Math.min(capacity, 0x40000000);
            this.drainBuffers(AMORTIZED_DRAIN_THRESHOLD);
            this.evict();
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    private boolean hasOverflowed() {
        return this.weightedSize > this.capacity;
    }

    private void evict() {
        while (this.hasOverflowed()) {
            Node node = this.evictionDeque.pollFirst();
            this.data.remove(node.key, node);
            node.makeDead();
        }
    }

    private void afterCompletion(Task task) {
        boolean delayable = this.schedule(task);
        if (this.shouldDrainBuffers(delayable)) {
            this.tryToDrainBuffers(AMORTIZED_DRAIN_THRESHOLD);
        }
    }

    private boolean schedule(Task task) {
        int index = ConcurrentLinkedHashMap.bufferIndex();
        int buffered = this.bufferLengths.incrementAndGet(index);
        if (task.isWrite()) {
            this.buffers[index].add(task);
            this.drainStatus.set(DrainStatus.REQUIRED);
            return false;
        }
        if (buffered <= 0x100000) {
            this.buffers[index].add(task);
            return buffered <= 16;
        }
        this.bufferLengths.decrementAndGet(index);
        return false;
    }

    private static int bufferIndex() {
        return (int)Thread.currentThread().getId() & BUFFER_MASK;
    }

    public int nextOrdering() {
        return this.nextOrder++;
    }

    private boolean shouldDrainBuffers(boolean delayable) {
        if (this.executor.isShutdown()) {
            DrainStatus status = this.drainStatus.get();
            return status != DrainStatus.PROCESSING && (!delayable || status == DrainStatus.REQUIRED);
        }
        return false;
    }

    private void tryToDrainBuffers(int maxToDrain) {
        if (this.evictionLock.tryLock()) {
            try {
                this.drainStatus.set(DrainStatus.PROCESSING);
                this.drainBuffers(maxToDrain);
            }
            finally {
                this.drainStatus.compareAndSet(DrainStatus.PROCESSING, DrainStatus.IDLE);
                this.evictionLock.unlock();
            }
        }
    }

    private void drainBuffers(int maxToDrain) {
        Task[] tasks = new Task[maxToDrain];
        int maxTaskIndex = this.moveTasksFromBuffers(tasks);
        this.runTasks(tasks, maxTaskIndex);
        this.updateDrainedOrder(tasks, maxTaskIndex);
    }

    private int moveTasksFromBuffers(Task[] tasks) {
        int maxTaskIndex = -1;
        for (int i = 0; i < this.buffers.length; ++i) {
            int maxIndex = this.moveTasksFromBuffer(tasks, i);
            maxTaskIndex = Math.max(maxIndex, maxTaskIndex);
        }
        return maxTaskIndex;
    }

    private int moveTasksFromBuffer(Task[] tasks, int bufferIndex) {
        Task task;
        Queue<Task> buffer = this.buffers[bufferIndex];
        int removedFromBuffer = 0;
        int maxIndex = -1;
        while ((task = buffer.poll()) != null) {
            ++removedFromBuffer;
            int index = task.getOrder() - this.drainedOrder;
            if (index < 0) {
                task.run();
                continue;
            }
            if (index >= tasks.length) {
                maxIndex = tasks.length - 1;
                this.addTaskToChain(tasks, task, maxIndex);
                break;
            }
            maxIndex = Math.max(index, maxIndex);
            this.addTaskToChain(tasks, task, index);
        }
        this.bufferLengths.addAndGet(bufferIndex, -removedFromBuffer);
        return maxIndex;
    }

    private void addTaskToChain(Task[] tasks, Task task, int index) {
        task.setNext(tasks[index]);
        tasks[index] = task;
    }

    private void runTasks(Task[] tasks, int maxTaskIndex) {
        for (int i = 0; i <= maxTaskIndex; ++i) {
            this.runTasksInChain(tasks[i]);
        }
    }

    private void runTasksInChain(Task task) {
        while (task != null) {
            Task current = task;
            task = task.getNext();
            current.setNext(null);
            current.run();
        }
    }

    private void updateDrainedOrder(Task[] tasks, int maxTaskIndex) {
        if (maxTaskIndex >= 0) {
            Task task = tasks[maxTaskIndex];
            this.drainedOrder = task.getOrder() + 1;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public int size() {
        return this.data.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.evictionLock.lock();
        try {
            Node node;
            while ((node = this.evictionDeque.poll()) != null) {
                this.data.remove(node.key, node);
                node.makeDead();
            }
            for (int i = 0; i < this.buffers.length; ++i) {
                Task task;
                Queue<Task> buffer = this.buffers[i];
                int removed = 0;
                while ((task = buffer.poll()) != null) {
                    if (task.isWrite()) {
                        task.run();
                    }
                    ++removed;
                }
                this.bufferLengths.addAndGet(i, -removed);
            }
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.data.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (Node node : this.data.values()) {
            if (!node.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        Node node = this.data.get(key);
        if (node == null) {
            return null;
        }
        this.afterCompletion(new ReadTask(node));
        return node.getValue();
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        return null;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return null;
    }

    @Override
    public boolean remove(Object key, Object value) {
        return false;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return false;
    }

    @Override
    public V replace(K key, V value) {
        return null;
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return null;
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return null;
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return null;
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return null;
    }

    @Override
    public V put(K key, V value) {
        WeightedValue oldWeightedValue;
        Node prior;
        int weight = this.weigher.weightOf(value);
        WeightedValue<V> weightedValue = new WeightedValue<V>(value, weight);
        Node node = new Node(key, weightedValue);
        block0: while (true) {
            if ((prior = this.data.putIfAbsent(node.key, node)) == null) {
                this.afterCompletion(new AddTask(node, weight));
                return null;
            }
            do {
                if (!(oldWeightedValue = (WeightedValue)prior.get()).isAlive()) continue block0;
            } while (!prior.compareAndSet(oldWeightedValue, weightedValue));
            break;
        }
        int weightedDifference = weight - oldWeightedValue.weight;
        ReadTask task = weightedDifference == 0 ? new ReadTask(prior) : new UpdateTask(prior, weightedDifference);
        this.afterCompletion(task);
        return (V)oldWeightedValue.value;
    }

    @Override
    public V remove(Object key) {
        Node node = this.data.remove(key);
        if (node == null) {
            return null;
        }
        node.makeRetired();
        this.afterCompletion(new RemovalTask(node));
        return node.getValue();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
    }

    @Override
    public Set<K> keySet() {
        KeySet ks = this.keySet;
        return ks == null ? (this.keySet = new KeySet()) : ks;
    }

    @Override
    public Collection<V> values() {
        return null;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es == null ? (this.entrySet = new EntrySet()) : es;
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    static {
        int buffers = ConcurrentLinkedHashMap.ceilingNextPowerOfTwo(Runtime.getRuntime().availableProcessors());
        AMORTIZED_DRAIN_THRESHOLD = (1 + buffers) * 16;
        NUMBER_OF_BUFFERS = buffers;
        BUFFER_MASK = buffers - 1;
    }

    private abstract class AbstractTask
    implements Task {
        private final int order;
        private Task task;

        public AbstractTask() {
            this.order = ConcurrentLinkedHashMap.this.nextOrdering();
        }

        @Override
        public int getOrder() {
            return this.order;
        }

        @Override
        public Task getNext() {
            return this.task;
        }

        @Override
        public void setNext(Task task) {
            this.task = task;
        }
    }

    private static interface Task
    extends Runnable {
        public int getOrder();

        public boolean isWrite();

        public Task getNext();

        public void setNext(Task var1);
    }

    private static final class DisabledExecutorService
    extends AbstractExecutorService {
        private DisabledExecutorService() {
        }

        @Override
        public void shutdown() {
        }

        @Override
        public List<Runnable> shutdownNow() {
            return null;
        }

        @Override
        public boolean isShutdown() {
            return true;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return false;
        }

        @Override
        public void execute(Runnable command) {
        }
    }

    private class WriteThroughEntry
    extends AbstractMap.SimpleEntry<K, V> {
        private static final long serialVersionUID = 1L;

        public WriteThroughEntry(Node node) {
            super(node.key, node.getValue());
        }
    }

    private final class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Node> iterator;
        Node current;

        private EntryIterator() {
            this.iterator = ConcurrentLinkedHashMap.this.data.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            this.current = this.iterator.next();
            return new WriteThroughEntry(this.current);
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException("Node can't be null");
            }
            ConcurrentLinkedHashMap.this.remove(this.current.key);
            this.current = null;
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public int size() {
            return 0;
        }
    }

    private final class KeySet
    extends AbstractSet<K> {
        final ConcurrentLinkedHashMap<K, V> map;

        private KeySet() {
            this.map = ConcurrentLinkedHashMap.this;
        }

        @Override
        public Iterator<K> iterator() {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return ((ConcurrentHashMap.CollectionView)((Object)this.map.data.keySet())).toArray(array);
        }
    }

    private class Node
    extends AtomicReference<WeightedValue<V>>
    implements Linked<Node> {
        private static final long serialVersionUID = 1L;
        private K key;
        private Node prev;
        private Node next;

        Node(K key, WeightedValue<V> weightedValue) {
            super(weightedValue);
            this.key = key;
        }

        @Override
        public Node getPrevious() {
            return this.prev;
        }

        @Override
        public void setPrevious(Node prev) {
            this.prev = prev;
        }

        @Override
        public Node getNext() {
            return this.next;
        }

        @Override
        public void setNext(Node next) {
            this.next = next;
        }

        V getValue() {
            return ((WeightedValue)this.get()).value;
        }

        public void makeRetired() {
            WeightedValue<Object> retired;
            WeightedValue current;
            do {
                if ((current = (WeightedValue)this.get()).isAlive()) continue;
                return;
            } while (!this.compareAndSet(current, retired = new WeightedValue<Object>(current.value, -current.weight)));
        }

        public void makeDead() {
            WeightedValue<Object> dead;
            WeightedValue current;
            while (!this.compareAndSet(current = (WeightedValue)this.get(), dead = new WeightedValue<Object>(current.value, 0))) {
            }
            ConcurrentLinkedHashMap.this.weightedSize -= Math.abs(current.weight);
        }
    }

    private static final class WeightedValue<V> {
        private final int weight;
        private final V value;

        WeightedValue(V value, int weight) {
            this.weight = weight;
            this.value = value;
        }

        boolean hasValue(Object o) {
            return o == this.value || this.value.equals(o);
        }

        boolean isAlive() {
            return this.weight > 0;
        }
    }

    private final class UpdateTask
    extends ReadTask {
        final int weightDifference;

        public UpdateTask(Node node, int weightDifference) {
            super(node);
            this.weightDifference = weightDifference;
        }

        @Override
        public void run() {
            super.run();
            ConcurrentLinkedHashMap.this.weightedSize += this.weightDifference;
        }

        @Override
        public boolean isWrite() {
            return true;
        }
    }

    private final class RemovalTask
    extends AbstractTask {
        final Node node;

        RemovalTask(Node node) {
            this.node = node;
        }

        @Override
        public void run() {
            ConcurrentLinkedHashMap.this.evictionDeque.remove(this.node);
            this.node.makeDead();
        }

        @Override
        public boolean isWrite() {
            return true;
        }
    }

    private final class AddTask
    extends AbstractTask {
        final Node node;
        final int weight;

        AddTask(Node node, int weight) {
            this.weight = weight;
            this.node = node;
        }

        @Override
        public void run() {
            ConcurrentLinkedHashMap.this.weightedSize += this.weight;
            if (((WeightedValue)this.node.get()).isAlive()) {
                ConcurrentLinkedHashMap.this.evictionDeque.add(this.node);
            }
        }

        @Override
        public boolean isWrite() {
            return true;
        }
    }

    private class ReadTask
    extends AbstractTask {
        final Node node;

        ReadTask(Node node) {
            this.node = node;
        }

        @Override
        public void run() {
            if (ConcurrentLinkedHashMap.this.evictionDeque.contains(this.node)) {
                ConcurrentLinkedHashMap.this.evictionDeque.moveToBack(this.node);
            }
        }

        @Override
        public boolean isWrite() {
            return false;
        }
    }

    static enum DrainStatus {
        IDLE,
        REQUIRED,
        PROCESSING;

    }
}

