/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core;

import io.ballerina.messaging.broker.common.ValidationException;
import io.ballerina.messaging.broker.common.data.types.FieldValue;
import io.ballerina.messaging.broker.core.Binding;
import io.ballerina.messaging.broker.core.Queue;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class BindingSet {
    private static final BindingSet EMPTY_SET = new EmptyBindingSet();
    private final Map<Queue, Binding> filteredQueueBindings = new ConcurrentHashMap<Queue, Binding>();
    private final Map<Queue, Binding> unfilteredQueueBindings = new ConcurrentHashMap<Queue, Binding>();

    public static BindingSet emptySet() {
        return EMPTY_SET;
    }

    BindingSet() {
    }

    boolean add(Binding binding) throws ValidationException {
        Binding existingBinding = this.validateBinding(binding);
        if (Objects.isNull(existingBinding)) {
            FieldValue selectorValue = binding.getArgument(Binding.JMS_SELECTOR_ARGUMENT);
            Map<Queue, Binding> queueBindingMap = Objects.nonNull(selectorValue) && !selectorValue.getValue().toString().isEmpty() ? this.filteredQueueBindings : this.unfilteredQueueBindings;
            queueBindingMap.put(binding.getQueue(), binding);
            return true;
        }
        return false;
    }

    private Binding validateBinding(Binding binding) throws ValidationException {
        Binding existingBinding = this.unfilteredQueueBindings.get(binding.getQueue());
        if (Objects.isNull(existingBinding)) {
            existingBinding = this.filteredQueueBindings.get(binding.getQueue());
        }
        if (Objects.nonNull(existingBinding) && !existingBinding.equals(binding)) {
            throw new ValidationException("Similar binding with different arguments already exist.");
        }
        return existingBinding;
    }

    void add(BindingSet bindingSet) {
        bindingSet.filteredQueueBindings.forEach(this.filteredQueueBindings::put);
        bindingSet.unfilteredQueueBindings.forEach(this.unfilteredQueueBindings::put);
    }

    public void remove(Queue queue) {
        Binding binding = this.filteredQueueBindings.remove(queue);
        if (Objects.isNull(binding)) {
            binding = this.unfilteredQueueBindings.remove(queue);
        }
        if (Objects.nonNull(binding)) {
            queue.getQueueHandler().removeBinding(binding);
        }
    }

    public Collection<Binding> getUnfilteredBindings() {
        return this.unfilteredQueueBindings.values();
    }

    boolean isEmpty() {
        return this.filteredQueueBindings.isEmpty() && this.unfilteredQueueBindings.isEmpty();
    }

    public Collection<Binding> getFilteredBindings() {
        return this.filteredQueueBindings.values();
    }

    private static class EmptyBindingSet
    extends BindingSet {
        private EmptyBindingSet() {
        }

        @Override
        boolean add(Binding binding) {
            throw new UnsupportedOperationException("Cannot modify Unmodifiable binding set.");
        }

        @Override
        void add(BindingSet bindingSet) {
            throw new UnsupportedOperationException("Cannot modify Unmodifiable binding set.");
        }

        @Override
        public void remove(Queue queue) {
            throw new UnsupportedOperationException("Cannot modify Unmodifiable binding set.");
        }

        @Override
        boolean isEmpty() {
            return true;
        }
    }
}

