/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.ballerina.messaging.broker.auth.AuthManager;
import io.ballerina.messaging.broker.auth.authorization.Authorizer;
import io.ballerina.messaging.broker.auth.authorization.authorizer.empty.NoOpAuthorizer;
import io.ballerina.messaging.broker.common.ResourceNotFoundException;
import io.ballerina.messaging.broker.common.StartupContext;
import io.ballerina.messaging.broker.common.ValidationException;
import io.ballerina.messaging.broker.common.config.BrokerCommonConfiguration;
import io.ballerina.messaging.broker.common.config.BrokerConfigProvider;
import io.ballerina.messaging.broker.common.data.types.FieldTable;
import io.ballerina.messaging.broker.coordination.BasicHaListener;
import io.ballerina.messaging.broker.coordination.HaListener;
import io.ballerina.messaging.broker.coordination.HaStrategy;
import io.ballerina.messaging.broker.core.Binding;
import io.ballerina.messaging.broker.core.BindingSet;
import io.ballerina.messaging.broker.core.Broker;
import io.ballerina.messaging.broker.core.BrokerException;
import io.ballerina.messaging.broker.core.BrokerFactory;
import io.ballerina.messaging.broker.core.Consumer;
import io.ballerina.messaging.broker.core.DefaultBrokerFactory;
import io.ballerina.messaging.broker.core.DetachableMessage;
import io.ballerina.messaging.broker.core.Exchange;
import io.ballerina.messaging.broker.core.ExchangeRegistry;
import io.ballerina.messaging.broker.core.Message;
import io.ballerina.messaging.broker.core.MessageDeliveryTask;
import io.ballerina.messaging.broker.core.MessageDeliveryTaskFactory;
import io.ballerina.messaging.broker.core.Metadata;
import io.ballerina.messaging.broker.core.QueueHandler;
import io.ballerina.messaging.broker.core.QueueRegistry;
import io.ballerina.messaging.broker.core.SecureBrokerFactory;
import io.ballerina.messaging.broker.core.configuration.BrokerCoreConfiguration;
import io.ballerina.messaging.broker.core.metrics.BrokerMetricManager;
import io.ballerina.messaging.broker.core.metrics.DefaultBrokerMetricManager;
import io.ballerina.messaging.broker.core.metrics.NullBrokerMetricManager;
import io.ballerina.messaging.broker.core.rest.api.ExchangesApi;
import io.ballerina.messaging.broker.core.rest.api.QueuesApi;
import io.ballerina.messaging.broker.core.store.DbBackedStoreFactory;
import io.ballerina.messaging.broker.core.store.MemBackedStoreFactory;
import io.ballerina.messaging.broker.core.store.MessageStore;
import io.ballerina.messaging.broker.core.store.StoreFactory;
import io.ballerina.messaging.broker.core.task.TaskExecutorService;
import io.ballerina.messaging.broker.core.transaction.BrokerTransaction;
import io.ballerina.messaging.broker.core.transaction.BrokerTransactionFactory;
import io.ballerina.messaging.broker.core.util.MessageTracer;
import io.ballerina.messaging.broker.rest.BrokerServiceRunner;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.sql.DataSource;
import javax.transaction.xa.Xid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.core.MetricService;

public final class BrokerImpl
implements Broker {
    private static final Logger LOGGER = LoggerFactory.getLogger(BrokerImpl.class);
    public static final String DEFAULT_DEAD_LETTER_QUEUE = "amq.dlq";
    public static final String ORIGIN_QUEUE_HEADER = "x-origin-queue";
    public static final String ORIGIN_EXCHANGE_HEADER = "x-origin-exchange";
    public static final String ORIGIN_ROUTING_KEY_HEADER = "x-origin-routing-key";
    private final BrokerMetricManager metricManager;
    private HaStrategy haStrategy;
    private BrokerHelper brokerHelper;
    private final BrokerTransactionFactory brokerTransactionFactory;
    private final QueueRegistry queueRegistry;
    private final TaskExecutorService<MessageDeliveryTask> deliveryTaskService;
    private final ExchangeRegistry exchangeRegistry;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final MessageStore messageStore;
    private final MessageDeliveryTaskFactory messageDeliveryTaskFactory;

    public BrokerImpl(StartupContext startupContext) throws Exception {
        MetricService metrics = (MetricService)startupContext.getService(MetricService.class);
        this.metricManager = this.getMetricManager(metrics);
        BrokerConfigProvider configProvider = (BrokerConfigProvider)startupContext.getService(BrokerConfigProvider.class);
        BrokerCoreConfiguration configuration = (BrokerCoreConfiguration)configProvider.getConfigurationObject("ballerina.broker.core", BrokerCoreConfiguration.class);
        StoreFactory storeFactory = this.getStoreFactory(startupContext, configProvider, configuration);
        this.exchangeRegistry = storeFactory.getExchangeRegistry();
        this.messageStore = storeFactory.getMessageStore();
        this.queueRegistry = storeFactory.getQueueRegistry();
        this.exchangeRegistry.retrieveFromStore(this.queueRegistry);
        this.deliveryTaskService = this.createTaskExecutorService(configuration);
        this.messageDeliveryTaskFactory = new MessageDeliveryTaskFactory(configuration.getDeliveryTask());
        this.initDefaultDeadLetterQueue();
        this.brokerTransactionFactory = new BrokerTransactionFactory(this, this.messageStore);
        this.brokerTransactionFactory.syncWithMessageStore(this.messageStore);
        startupContext.registerService(Broker.class, (Object)this);
        this.initRestApi(startupContext);
        this.initHaSupport(startupContext);
    }

    private StoreFactory getStoreFactory(StartupContext startupContext, BrokerConfigProvider configProvider, BrokerCoreConfiguration configuration) throws Exception {
        BrokerCommonConfiguration commonConfigs = (BrokerCommonConfiguration)configProvider.getConfigurationObject("ballerina.broker", BrokerCommonConfiguration.class);
        if (Objects.isNull(commonConfigs)) {
            commonConfigs = new BrokerCommonConfiguration();
        }
        DataSource dataSource = (DataSource)startupContext.getService(DataSource.class);
        if (commonConfigs.getEnableInMemoryMode()) {
            return new MemBackedStoreFactory(this.metricManager, configuration);
        }
        return new DbBackedStoreFactory(dataSource, this.metricManager, configuration);
    }

    private void initRestApi(StartupContext startupContext) {
        BrokerServiceRunner serviceRunner = (BrokerServiceRunner)startupContext.getService(BrokerServiceRunner.class);
        if (Objects.nonNull(serviceRunner)) {
            NoOpAuthorizer dacHandler;
            BrokerFactory brokerFactory;
            AuthManager authManager = (AuthManager)startupContext.getService(AuthManager.class);
            if (null != authManager && authManager.isAuthenticationEnabled() && authManager.isAuthorizationEnabled()) {
                brokerFactory = new SecureBrokerFactory(startupContext);
                dacHandler = authManager.getAuthorizer();
            } else {
                brokerFactory = new DefaultBrokerFactory(startupContext);
                dacHandler = new NoOpAuthorizer();
            }
            serviceRunner.deploy(new Object[]{new QueuesApi(brokerFactory, (Authorizer)dacHandler), new ExchangesApi(brokerFactory, (Authorizer)dacHandler)});
        }
    }

    private void initHaSupport(StartupContext startupContext) {
        this.haStrategy = (HaStrategy)startupContext.getService(HaStrategy.class);
        if (this.haStrategy == null) {
            this.brokerHelper = new BrokerHelper();
        } else {
            LOGGER.info("Broker is in PASSIVE mode");
            this.brokerHelper = new HaEnabledBrokerHelper();
        }
    }

    private void initDefaultDeadLetterQueue() throws BrokerException, ValidationException {
        this.createQueue(DEFAULT_DEAD_LETTER_QUEUE, false, true, false);
        this.bind(DEFAULT_DEAD_LETTER_QUEUE, "amq.dlx", DEFAULT_DEAD_LETTER_QUEUE, FieldTable.EMPTY_TABLE);
    }

    private BrokerMetricManager getMetricManager(MetricService metrics) {
        if (Objects.nonNull(metrics)) {
            return new DefaultBrokerMetricManager(metrics);
        }
        return new NullBrokerMetricManager();
    }

    private TaskExecutorService<MessageDeliveryTask> createTaskExecutorService(BrokerCoreConfiguration configuration) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("MessageDeliveryTaskThreadPool-%d").build();
        int workerCount = Integer.parseInt(configuration.getDeliveryTask().getWorkerCount());
        int idleTaskDelay = Integer.parseInt(configuration.getDeliveryTask().getIdleTaskDelay());
        return new TaskExecutorService<MessageDeliveryTask>(workerCount, idleTaskDelay, threadFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(Message message) throws BrokerException {
        block8: {
            this.lock.readLock().lock();
            try {
                Metadata metadata = message.getMetadata();
                Exchange exchange = this.exchangeRegistry.getExchange(metadata.getExchangeName());
                if (exchange != null) {
                    String routingKey = metadata.getRoutingKey();
                    BindingSet bindingSet = exchange.getBindingsForRoute(routingKey);
                    if (bindingSet.isEmpty()) {
                        LOGGER.info("Dropping message since no queues found for routing key {} in {}", (Object)routingKey, (Object)exchange);
                        MessageTracer.trace(message, "No routes for message. Message dropped!");
                        break block8;
                    }
                    try {
                        this.messageStore.add(message.shallowCopy());
                        Set<QueueHandler> uniqueQueues = this.getUniqueQueueHandlersForBinding(metadata, bindingSet);
                        this.publishToQueues(message, uniqueQueues);
                        break block8;
                    }
                    finally {
                        this.messageStore.flush(message.getInternalId());
                    }
                }
                MessageTracer.trace(message, "Unknown exchange. Message dropped!");
                throw new BrokerException("Message publish failed. Unknown exchange: " + metadata.getExchangeName());
            }
            finally {
                this.lock.readLock().unlock();
                message.release();
            }
        }
    }

    private Set<QueueHandler> getUniqueQueueHandlersForBinding(Metadata metadata, BindingSet bindingSet) {
        HashSet<QueueHandler> uniqueQueues = new HashSet<QueueHandler>();
        for (Binding binding : bindingSet.getUnfilteredBindings()) {
            uniqueQueues.add(binding.getQueue().getQueueHandler());
        }
        for (Binding binding : bindingSet.getFilteredBindings()) {
            if (!binding.getFilterExpression().evaluate(metadata)) continue;
            uniqueQueues.add(binding.getQueue().getQueueHandler());
        }
        return uniqueQueues;
    }

    private void publishToQueues(Message message, Set<QueueHandler> uniqueQueueHandlers) throws BrokerException {
        if (uniqueQueueHandlers.isEmpty()) {
            LOGGER.info("Dropping message since message didn't have any routes to {}", (Object)message.getMetadata().getRoutingKey());
            MessageTracer.trace(message, "No routes for message. Message dropped!");
            return;
        }
        for (QueueHandler handler : uniqueQueueHandlers) {
            handler.enqueue(message.shallowCopy());
        }
        this.metricManager.markPublish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acknowledge(String queueName, DetachableMessage detachableMessage) throws BrokerException {
        this.lock.readLock().lock();
        try {
            QueueHandler queueHandler = this.queueRegistry.getQueueHandler(queueName);
            queueHandler.dequeue(detachableMessage);
            this.metricManager.markAcknowledge();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Set<QueueHandler> enqueue(Xid xid, Message message) throws BrokerException {
        this.lock.readLock().lock();
        try {
            Metadata metadata = message.getMetadata();
            Exchange exchange = this.exchangeRegistry.getExchange(metadata.getExchangeName());
            if (Objects.nonNull(exchange)) {
                BindingSet bindingsForRoute = exchange.getBindingsForRoute(metadata.getRoutingKey());
                Set<QueueHandler> uniqueQueueHandlers = this.getUniqueQueueHandlersForBinding(metadata, bindingsForRoute);
                if (uniqueQueueHandlers.isEmpty()) {
                    MessageTracer.trace(message, xid, "No routes for message. Message dropped!");
                    Set<QueueHandler> set = uniqueQueueHandlers;
                    return set;
                }
                this.messageStore.add(xid, message.shallowCopy());
                for (QueueHandler handler : uniqueQueueHandlers) {
                    handler.prepareForEnqueue(xid, message.shallowCopy());
                }
                Set<QueueHandler> set = uniqueQueueHandlers;
                return set;
            }
            MessageTracer.trace(message, xid, "Unknown exchange. Message dropped!");
            throw new BrokerException("Message published to unknown exchange " + metadata.getExchangeName());
        }
        finally {
            this.lock.readLock().unlock();
            message.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueueHandler dequeue(Xid xid, String queueName, DetachableMessage detachableMessage) throws BrokerException {
        this.lock.readLock().lock();
        try {
            QueueHandler queueHandler = this.queueRegistry.getQueueHandler(queueName);
            queueHandler.prepareForDetach(xid, detachableMessage);
            QueueHandler queueHandler2 = queueHandler;
            return queueHandler2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConsumer(Consumer consumer) throws BrokerException {
        block9: {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Consume request received for {}", (Object)consumer.getQueueName());
            }
            this.lock.readLock().lock();
            try {
                QueueHandler queueHandler = this.queueRegistry.getQueueHandler(consumer.getQueueName());
                if (queueHandler != null) {
                    QueueHandler queueHandler2 = queueHandler;
                    synchronized (queueHandler2) {
                        if (queueHandler.addConsumer(consumer) && queueHandler.consumerCount() == 1) {
                            this.deliveryTaskService.add(this.messageDeliveryTaskFactory.create(queueHandler));
                        }
                        break block9;
                    }
                }
                throw new BrokerException("Cannot add consumer. Queue [ " + consumer.getQueueName() + " ] not found. Create the queue before attempting to consume.");
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeConsumer(Consumer consumer) {
        QueueHandler queueHandler;
        boolean queueDeletable;
        block11: {
            this.lock.readLock().lock();
            queueDeletable = false;
            try {
                queueHandler = this.queueRegistry.getQueueHandler(consumer.getQueueName());
                if (queueHandler == null) break block11;
                QueueHandler queueHandler2 = queueHandler;
                synchronized (queueHandler2) {
                    if (queueHandler.removeConsumer(consumer) && queueHandler.consumerCount() == 0) {
                        this.deliveryTaskService.remove(queueHandler.getUnmodifiableQueue().getName());
                        if (queueHandler.getUnmodifiableQueue().isAutoDelete()) {
                            queueDeletable = true;
                        }
                    }
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        if (queueDeletable) {
            try {
                this.deleteQueue(queueHandler.getUnmodifiableQueue().getName(), true, false);
            }
            catch (ResourceNotFoundException | ValidationException | BrokerException e) {
                LOGGER.warn("Exception while auto deleting the queue {}", (Object)queueHandler.getUnmodifiableQueue(), (Object)e);
            }
        }
        return queueDeletable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void declareExchange(String exchangeName, String type, boolean passive, boolean durable) throws BrokerException, ValidationException {
        this.lock.writeLock().lock();
        try {
            this.exchangeRegistry.declareExchange(exchangeName, type, passive, durable);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createExchange(String exchangeName, String type, boolean durable) throws BrokerException, ValidationException {
        this.lock.writeLock().lock();
        try {
            this.exchangeRegistry.createExchange(exchangeName, Exchange.Type.from(type), durable);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteExchange(String exchangeName, boolean ifUnused) throws BrokerException, ValidationException {
        this.lock.writeLock().lock();
        try {
            boolean bl = this.exchangeRegistry.deleteExchange(exchangeName, ifUnused);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createQueue(String queueName, boolean passive, boolean durable, boolean autoDelete) throws BrokerException, ValidationException {
        this.lock.writeLock().lock();
        try {
            boolean queueAdded = this.queueRegistry.addQueue(queueName, passive, durable, autoDelete);
            if (queueAdded) {
                QueueHandler queueHandler = this.queueRegistry.getQueueHandler(queueName);
                this.exchangeRegistry.getDefaultExchange().bind(queueHandler, queueName, FieldTable.EMPTY_TABLE);
            }
            boolean bl = queueAdded;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteQueue(String queueName, boolean ifUnused, boolean ifEmpty) throws BrokerException, ValidationException, ResourceNotFoundException {
        this.lock.writeLock().lock();
        try {
            int n = this.queueRegistry.removeQueue(queueName, ifUnused, ifEmpty);
            return n;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean queueExists(String queueName) {
        this.lock.readLock().lock();
        try {
            boolean bl = Objects.nonNull(this.queueRegistry.getQueueHandler(queueName));
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(String queueName, String exchangeName, String routingKey, FieldTable arguments) throws BrokerException, ValidationException {
        this.lock.writeLock().lock();
        try {
            Exchange exchange = this.exchangeRegistry.getExchange(exchangeName);
            QueueHandler queueHandler = this.queueRegistry.getQueueHandler(queueName);
            if (exchange == null) {
                throw new ValidationException("Unknown exchange name: " + exchangeName);
            }
            if (queueHandler == null) {
                throw new ValidationException("Unknown queue name: " + queueName);
            }
            if (!routingKey.isEmpty()) {
                exchange.bind(queueHandler, routingKey, arguments);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbind(String queueName, String exchangeName, String routingKey) throws BrokerException, ValidationException {
        this.lock.writeLock().lock();
        try {
            Exchange exchange = this.exchangeRegistry.getExchange(exchangeName);
            QueueHandler queueHandler = this.queueRegistry.getQueueHandler(queueName);
            if (exchange == null) {
                throw new ValidationException("Unknown exchange name: " + exchangeName);
            }
            if (queueHandler == null) {
                throw new ValidationException("Unknown queue name: " + queueName);
            }
            exchange.unbind(queueHandler.getUnmodifiableQueue(), routingKey);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void startMessageDelivery() {
        this.brokerHelper.startMessageDelivery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int purgeQueue(String queueName) throws ResourceNotFoundException, ValidationException {
        this.lock.writeLock().lock();
        try {
            QueueHandler queueHandler = this.queueRegistry.getQueueHandler(queueName);
            if (queueHandler == null) {
                throw new ResourceNotFoundException("Queue [ " + queueName + " ] Not found");
            }
            int n = queueHandler.purgeQueue();
            return n;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void stopMessageDelivery() {
        LOGGER.info("Stopping message delivery threads.");
        this.deliveryTaskService.stop();
    }

    @Override
    public void shutdown() {
        this.brokerHelper.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requeue(String queueName, Message message) throws BrokerException, ResourceNotFoundException {
        this.lock.readLock().lock();
        try {
            QueueHandler queueHandler = this.queueRegistry.getQueueHandler(queueName);
            if (Objects.isNull(queueHandler)) {
                message.release();
                throw new ResourceNotFoundException("Queue [ " + queueName + " ] Not found");
            }
            queueHandler.requeue(message);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Collection<QueueHandler> getAllQueues() {
        this.lock.readLock().lock();
        try {
            Collection<QueueHandler> collection = this.queueRegistry.getAllQueues();
            return collection;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueueHandler getQueue(String queueName) throws ResourceNotFoundException {
        this.lock.readLock().lock();
        try {
            QueueHandler queueHandler = this.queueRegistry.getQueueHandler(queueName);
            if (Objects.isNull(queueHandler)) {
                throw new ResourceNotFoundException("Queue [ " + queueName + " ] Not found");
            }
            QueueHandler queueHandler2 = queueHandler;
            return queueHandler2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveToDlc(String queueName, Message message) throws BrokerException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Moving message to DLC: {}", (Object)message);
        }
        try {
            Message dlcMessage = message.shallowCopyWith(Broker.getNextMessageId(), DEFAULT_DEAD_LETTER_QUEUE, "amq.dlx");
            dlcMessage.getMetadata().addHeader(ORIGIN_QUEUE_HEADER, queueName);
            dlcMessage.getMetadata().addHeader(ORIGIN_EXCHANGE_HEADER, message.getMetadata().getExchangeName());
            dlcMessage.getMetadata().addHeader(ORIGIN_ROUTING_KEY_HEADER, message.getMetadata().getRoutingKey());
            this.publish(dlcMessage);
            this.acknowledge(queueName, message.getDetachableMessage());
        }
        finally {
            message.release();
        }
    }

    @Override
    public Collection<Exchange> getAllExchanges() {
        this.lock.readLock().lock();
        try {
            Collection<Exchange> collection = this.exchangeRegistry.getAllExchanges();
            return collection;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, BindingSet> getAllBindingsForExchange(String exchangeName) throws ValidationException {
        this.lock.readLock().lock();
        try {
            Exchange exchange = this.exchangeRegistry.getExchange(exchangeName);
            if (Objects.isNull(exchange)) {
                throw new ValidationException("Non existing exchange name " + exchangeName);
            }
            Map<String, BindingSet> map = exchange.getBindingsRegistry().getAllBindings();
            return map;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Exchange getExchange(String exchangeName) {
        this.lock.readLock().lock();
        try {
            Exchange exchange = this.exchangeRegistry.getExchange(exchangeName);
            return exchange;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public BrokerTransaction newLocalTransaction() {
        return this.brokerTransactionFactory.newLocalTransaction();
    }

    @Override
    public BrokerTransaction newDistributedTransaction() {
        return this.brokerTransactionFactory.newDistributedTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<QueueHandler> restoreDtxPreparedMessages(Xid xid, Collection<Message> messages) throws BrokerException {
        HashSet<QueueHandler> queueHandlers = new HashSet<QueueHandler>();
        this.lock.readLock().lock();
        try {
            for (Message message : messages) {
                try {
                    this.messageStore.add(xid, message.shallowCopy());
                    for (String queueName : message.getAttachedDurableQueues()) {
                        QueueHandler queueHandler = this.queueRegistry.getQueueHandler(queueName);
                        queueHandler.prepareForEnqueue(xid, message.shallowCopy());
                        queueHandlers.add(queueHandler);
                    }
                }
                finally {
                    message.release();
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return queueHandlers;
    }

    private class HaEnabledBrokerHelper
    extends BrokerHelper
    implements HaListener {
        private BasicHaListener basicHaListener;

        HaEnabledBrokerHelper() {
            this.basicHaListener = new BasicHaListener((HaListener)this);
            BrokerImpl.this.haStrategy.registerListener((HaListener)this.basicHaListener, 1);
        }

        @Override
        public synchronized void startMessageDelivery() {
            this.basicHaListener.setStartCalled();
            if (!this.basicHaListener.isActive()) {
                return;
            }
            super.startMessageDelivery();
        }

        @Override
        public void shutdown() {
            BrokerImpl.this.haStrategy.unregisterListener((HaListener)this.basicHaListener);
            super.shutdown();
        }

        public void activate() {
            try {
                BrokerImpl.this.queueRegistry.reloadQueuesOnBecomingActive();
                BrokerImpl.this.exchangeRegistry.reloadExchangesOnBecomingActive(BrokerImpl.this.queueRegistry);
                BrokerImpl.this.brokerTransactionFactory.syncWithMessageStore(BrokerImpl.this.messageStore);
            }
            catch (BrokerException e) {
                LOGGER.error("Error on loading data from the database on becoming active ", (Throwable)e);
            }
            this.startMessageDeliveryOnBecomingActive();
            LOGGER.info("Broker mode changed from PASSIVE to ACTIVE");
        }

        public void deactivate() {
            BrokerImpl.this.stopMessageDelivery();
            LOGGER.info("Broker mode changed from ACTIVE to PASSIVE");
        }

        private synchronized void startMessageDeliveryOnBecomingActive() {
            if (this.basicHaListener.isStartCalled()) {
                this.startMessageDelivery();
            }
        }
    }

    private class BrokerHelper {
        private BrokerHelper() {
        }

        public void startMessageDelivery() {
            LOGGER.info("Starting message delivery threads.");
            BrokerImpl.this.deliveryTaskService.start();
        }

        public void shutdown() {
            BrokerImpl.this.stopMessageDelivery();
        }
    }
}

