/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core;

import io.ballerina.messaging.broker.core.BrokerException;
import io.ballerina.messaging.broker.core.QueueHandler;
import io.ballerina.messaging.broker.core.QueueHandlerFactory;
import io.ballerina.messaging.broker.core.configuration.BrokerCoreConfiguration;
import io.ballerina.messaging.broker.core.metrics.BrokerMetricManager;
import io.ballerina.messaging.broker.core.queue.DbBackedQueueImpl;
import io.ballerina.messaging.broker.core.queue.MemQueueImpl;
import io.ballerina.messaging.broker.core.queue.QueueBufferFactory;
import io.ballerina.messaging.broker.core.store.DbMessageStore;

public class DbBackedQueueHandlerFactory
implements QueueHandlerFactory {
    private final DbMessageStore dbMessageStore;
    private final BrokerMetricManager metricManager;
    private final int nonDurableQueueMaxDepth;
    private QueueBufferFactory queueBufferFactory;

    public DbBackedQueueHandlerFactory(DbMessageStore dbMessageStore, BrokerMetricManager metricManager, BrokerCoreConfiguration configuration) {
        this.dbMessageStore = dbMessageStore;
        this.metricManager = metricManager;
        this.nonDurableQueueMaxDepth = Integer.parseInt(configuration.getNonDurableQueueMaxDepth());
        this.queueBufferFactory = new QueueBufferFactory(configuration);
    }

    @Override
    public QueueHandler createDurableQueueHandler(String queueName, boolean autoDelete) throws BrokerException {
        DbBackedQueueImpl queue = new DbBackedQueueImpl(queueName, autoDelete, this.dbMessageStore, this.queueBufferFactory);
        return new QueueHandler(queue, this.metricManager);
    }

    @Override
    public QueueHandler createNonDurableQueueHandler(String queueName, boolean autoDelete) {
        MemQueueImpl queue = new MemQueueImpl(queueName, this.nonDurableQueueMaxDepth, autoDelete);
        return new QueueHandler(queue, this.metricManager);
    }
}

