/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core;

import io.ballerina.messaging.broker.common.ValidationException;
import io.ballerina.messaging.broker.core.BrokerException;
import io.ballerina.messaging.broker.core.DirectExchange;
import io.ballerina.messaging.broker.core.Exchange;
import io.ballerina.messaging.broker.core.QueueRegistry;
import io.ballerina.messaging.broker.core.TopicExchange;
import io.ballerina.messaging.broker.core.store.dao.BindingDao;
import io.ballerina.messaging.broker.core.store.dao.ExchangeDao;
import io.ballerina.messaging.broker.core.store.dao.impl.NoOpBindingDao;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public final class ExchangeRegistry {
    private static final String DIRECT = "amq.direct";
    private static final String TOPIC = "amq.topic";
    private static final String DEFAULT = "<<default>>";
    public static final String DEFAULT_DEAD_LETTER_EXCHANGE = "amq.dlx";
    private static final BindingDao NO_OP_BINDING_DAO = new NoOpBindingDao();
    private final Map<String, Exchange> exchangeMap = new ConcurrentHashMap<String, Exchange>(3);
    private final ExchangeDao exchangeDao;
    private final BindingDao bindingDao;
    private final Collection<Exchange> unmodifiableExchangesView;

    public ExchangeRegistry(ExchangeDao exchangeDao, BindingDao bindingDao) {
        this.exchangeMap.put(DIRECT, new DirectExchange(DIRECT, bindingDao));
        this.exchangeMap.put(TOPIC, new TopicExchange(TOPIC, bindingDao));
        this.exchangeMap.put(DEFAULT, new DirectExchange(DEFAULT, bindingDao));
        this.exchangeMap.put(DEFAULT_DEAD_LETTER_EXCHANGE, new DirectExchange(DEFAULT_DEAD_LETTER_EXCHANGE, bindingDao));
        this.exchangeDao = exchangeDao;
        this.bindingDao = bindingDao;
        this.unmodifiableExchangesView = Collections.unmodifiableCollection(this.exchangeMap.values());
    }

    Exchange getExchange(String exchangeName) {
        return this.exchangeMap.get(exchangeName);
    }

    boolean deleteExchange(String exchangeName, boolean ifUnused) throws BrokerException, ValidationException {
        Exchange exchange = this.exchangeMap.get(exchangeName);
        if (Objects.isNull(exchange)) {
            return false;
        }
        if (!this.isBuiltInExchange(exchange)) {
            if (!ifUnused || exchange.isUnused()) {
                if (exchange.isDurable()) {
                    this.exchangeDao.delete(exchange);
                }
                this.exchangeMap.remove(exchangeName);
                return true;
            }
            throw new ValidationException("Cannot delete exchange. Exchange " + exchangeName + " has bindings.");
        }
        throw new ValidationException("Cannot delete built in exchange '" + exchangeName + "'");
    }

    private boolean isBuiltInExchange(Exchange exchange) {
        String name = exchange.getName();
        return DEFAULT.equals(name) || DIRECT.equals(name) || TOPIC.equals(name);
    }

    void declareExchange(String exchangeName, String type, boolean passive, boolean durable) throws ValidationException, BrokerException {
        if (exchangeName.isEmpty()) {
            throw new ValidationException("Exchange name cannot be empty.");
        }
        Exchange exchange = this.exchangeMap.get(exchangeName);
        if (passive) {
            if (Objects.isNull(exchange)) {
                throw new ValidationException("Exchange [ " + exchangeName + " ] doesn't exists. Passive parameter is set, hence not creating the exchange.");
            }
        } else {
            this.createExchange(exchangeName, Exchange.Type.from(type), durable);
        }
    }

    public void createExchange(String exchangeName, Exchange.Type type, boolean durable) throws BrokerException, ValidationException {
        Exchange exchange = this.exchangeMap.get(exchangeName);
        if (Objects.isNull(exchange)) {
            BindingDao dao = durable ? this.bindingDao : NO_OP_BINDING_DAO;
            exchange = ExchangeFactory.newInstance(exchangeName, type, dao);
            this.exchangeMap.put(exchange.getName(), exchange);
            if (durable) {
                this.exchangeDao.persist(exchange);
            }
        } else {
            throw new ValidationException("Exchange [ " + exchangeName + " ] already exists.");
        }
    }

    private void retrieveAllExchangesFromDao() throws BrokerException {
        this.exchangeDao.retrieveAll((name, typeString) -> {
            Exchange exchange = ExchangeFactory.newInstance(name, Exchange.Type.from(typeString), this.bindingDao);
            this.exchangeMap.putIfAbsent(name, exchange);
        });
    }

    public Exchange getDefaultExchange() {
        return this.exchangeMap.get(DEFAULT);
    }

    public void retrieveFromStore(QueueRegistry queueRegistry) throws BrokerException {
        this.retrieveAllExchangesFromDao();
        for (Exchange exchange : this.exchangeMap.values()) {
            exchange.retrieveBindingsFromDb(queueRegistry);
        }
    }

    public Collection<Exchange> getAllExchanges() {
        return this.unmodifiableExchangesView;
    }

    void reloadExchangesOnBecomingActive(QueueRegistry queueRegistry) throws BrokerException {
        this.exchangeMap.clear();
        this.retrieveFromStore(queueRegistry);
    }

    public static class ExchangeFactory {
        private ExchangeFactory() {
        }

        public static Exchange newInstance(String exchangeName, Exchange.Type type, BindingDao bindingDao) throws BrokerException {
            Exchange exchange;
            switch (type) {
                case DIRECT: {
                    exchange = new DirectExchange(exchangeName, bindingDao);
                    break;
                }
                case TOPIC: {
                    exchange = new TopicExchange(exchangeName, bindingDao);
                    break;
                }
                default: {
                    throw new BrokerException("Unknown exchange type [ " + (Object)((Object)type) + " ].");
                }
            }
            return exchange;
        }
    }
}

