/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core;

import io.ballerina.messaging.broker.core.Consumer;
import io.ballerina.messaging.broker.core.CyclicConsumerIterator;
import io.ballerina.messaging.broker.core.Message;
import io.ballerina.messaging.broker.core.QueueHandler;
import io.ballerina.messaging.broker.core.task.Task;
import io.ballerina.messaging.broker.core.util.MessageTracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MessageDeliveryTask
extends Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageDeliveryTask.class);
    private final QueueHandler queueHandler;
    private final int deliveryBatchSize;

    MessageDeliveryTask(QueueHandler queueHandler, int deliveryBatchSize) {
        this.queueHandler = queueHandler;
        this.deliveryBatchSize = deliveryBatchSize;
    }

    @Override
    public void onAdd() {
    }

    @Override
    public void onRemove() {
    }

    @Override
    public String getId() {
        return this.queueHandler.getUnmodifiableQueue().getName();
    }

    @Override
    public Task.TaskHint call() throws Exception {
        CyclicConsumerIterator consumerIterator = this.queueHandler.getCyclicConsumerIterator();
        if (!consumerIterator.hasNext()) {
            return Task.TaskHint.IDLE;
        }
        int deliveredCount = 0;
        Consumer previousConsumer = null;
        while (true) {
            Consumer consumer;
            if (!(consumer = consumerIterator.next()).isReady()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Consumer {} is not ready for consuming messages from {}", (Object)consumer, (Object)this.queueHandler.getUnmodifiableQueue().getName());
                }
                if (consumer.equals(previousConsumer)) {
                    return Task.TaskHint.IDLE;
                }
                previousConsumer = consumer;
                continue;
            }
            Message message = this.queueHandler.takeForDelivery();
            if (message == null) break;
            LOGGER.debug("Sending message {} to {}", (Object)message, (Object)consumer);
            MessageTracer.trace(message, this.queueHandler, "Deliver message to transport consumer.");
            consumer.send(message);
            if (++deliveredCount == this.deliveryBatchSize) break;
            previousConsumer = consumer;
        }
        if (deliveredCount > 0) {
            return Task.TaskHint.ACTIVE;
        }
        return Task.TaskHint.IDLE;
    }
}

