/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core;

import io.ballerina.messaging.broker.common.data.types.FieldTable;
import io.ballerina.messaging.broker.common.data.types.FieldValue;
import io.ballerina.messaging.broker.common.data.types.ShortShortInt;
import io.ballerina.messaging.broker.common.data.types.ShortString;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;

public class Metadata {
    public static final ShortString DELIVERY_MODE = ShortString.parseString((String)"deliveryMode");
    public static final ShortString PRIORITY = ShortString.parseString((String)"priority");
    public static final ShortString EXPIRATION = ShortString.parseString((String)"expiration");
    public static final ShortString MESSAGE_ID = ShortString.parseString((String)"messageId");
    public static final ShortString CONTENT_TYPE = ShortString.parseString((String)"contentType");
    public static final ShortString CONTENT_ENCODING = ShortString.parseString((String)"contentEncoding");
    public static final ShortString CORRELATION_ID = ShortString.parseString((String)"correlationId");
    public static final int PERSISTENT_MESSAGE = 2;
    public static final int NON_PERSISTENT_MESSAGE = 1;
    private final String routingKey;
    private final String exchangeName;
    private final long contentLength;
    private FieldTable properties;
    private FieldTable headers;

    public Metadata(String routingKey, String exchangeName, long contentLength) {
        this.routingKey = routingKey;
        this.exchangeName = exchangeName;
        this.contentLength = contentLength;
        this.properties = new FieldTable();
        this.headers = new FieldTable();
    }

    public Metadata(String routingKey, String exchangeName, long contentLength, byte[] propertyBytes) throws Exception {
        this.routingKey = routingKey;
        this.exchangeName = exchangeName;
        this.contentLength = contentLength;
        this.properties = new FieldTable();
        this.headers = new FieldTable();
        this.setPropertiesFromBytes(propertyBytes);
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public String getExchangeName() {
        return this.exchangeName;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public Metadata shallowCopyWith(String routingKey, String exchangeName) {
        Metadata metadata = new Metadata(routingKey, exchangeName, this.contentLength);
        metadata.properties = this.properties;
        metadata.headers = this.headers;
        return metadata;
    }

    public String toString() {
        return "Metadata{routingKey='" + this.routingKey + '\'' + ", exchangeName='" + this.exchangeName + '\'' + ", correlationId='" + this.properties.getValue(CORRELATION_ID) + '\'' + ", contentLength='" + this.contentLength + '\'' + ", messageId='" + this.properties.getValue(MESSAGE_ID) + '\'' + ", deliveryMode='" + this.properties.getValue(DELIVERY_MODE) + '\'' + "'}";
    }

    public void setProperties(FieldTable properties) {
        this.properties = properties;
    }

    public void setHeaders(FieldTable headers) {
        this.headers = headers;
    }

    public FieldValue getProperty(ShortString propertyName) {
        return this.properties.getValue(propertyName);
    }

    public byte getByteProperty(ShortString propertyName) {
        FieldValue fieldValue = this.properties.getValue(propertyName);
        return ((ShortShortInt)fieldValue.getValue()).getByte();
    }

    public boolean isPersistent() {
        return this.getByteProperty(DELIVERY_MODE) == 2;
    }

    public FieldValue getHeader(ShortString headerName) {
        return this.headers.getValue(headerName);
    }

    public FieldTable getProperties() {
        return this.properties;
    }

    public FieldTable getHeaders() {
        return this.headers;
    }

    public void addHeader(String name, String value) {
        this.headers.add(ShortString.parseString((String)name), FieldValue.parseLongString((String)value));
    }

    public byte[] getPropertiesAsBytes() {
        long size = this.properties.getSize() + this.headers.getSize();
        byte[] bytes = new byte[(int)size];
        ByteBuf buffer = Unpooled.wrappedBuffer((byte[])bytes);
        buffer.resetWriterIndex();
        this.properties.write(buffer);
        this.headers.write(buffer);
        return bytes;
    }

    private void setPropertiesFromBytes(byte[] bytes) throws Exception {
        ByteBuf buffer = Unpooled.wrappedBuffer((byte[])bytes);
        this.properties = FieldTable.parse((ByteBuf)buffer);
        this.headers = FieldTable.parse((ByteBuf)buffer);
    }
}

