/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core;

import io.ballerina.messaging.broker.core.BrokerException;
import io.ballerina.messaging.broker.core.DetachableMessage;
import io.ballerina.messaging.broker.core.Message;
import io.ballerina.messaging.broker.core.QueueHandler;
import javax.transaction.xa.Xid;

public abstract class Queue {
    public static final int UNBOUNDED = Integer.MAX_VALUE;
    private final String name;
    private final boolean durable;
    private final boolean autoDelete;
    private QueueHandler queueHandler;

    public Queue(String queueName, boolean durable, boolean autoDelete) {
        this.name = queueName;
        this.durable = durable;
        this.autoDelete = autoDelete;
    }

    public final String getName() {
        return this.name;
    }

    public final boolean isDurable() {
        return this.durable;
    }

    public final boolean isAutoDelete() {
        return this.autoDelete;
    }

    public QueueHandler getQueueHandler() {
        return this.queueHandler;
    }

    final void setQueueHandler(QueueHandler queueHandler) {
        this.queueHandler = queueHandler;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Queue) {
            return this.name.equals(((Queue)obj).name);
        }
        return false;
    }

    public String toString() {
        return "Queue{name='" + this.name + '\'' + ", durable=" + this.durable + ", autoDelete=" + this.autoDelete + '}';
    }

    public final int hashCode() {
        return this.name.hashCode();
    }

    public abstract int capacity();

    public abstract int size();

    public abstract boolean enqueue(Message var1) throws BrokerException;

    public abstract void prepareEnqueue(Xid var1, Message var2) throws BrokerException;

    public abstract void commit(Xid var1);

    public abstract void rollback(Xid var1);

    public abstract Message dequeue();

    public abstract void detach(DetachableMessage var1) throws BrokerException;

    public abstract void prepareDetach(Xid var1, DetachableMessage var2) throws BrokerException;

    public abstract int clear();
}

