/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core;

import io.ballerina.messaging.broker.common.FastTopicMatcher;
import io.ballerina.messaging.broker.core.BindingSet;
import io.ballerina.messaging.broker.core.BindingsRegistryListener;
import io.ballerina.messaging.broker.core.Exchange;
import io.ballerina.messaging.broker.core.store.dao.BindingDao;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

final class TopicExchange
extends Exchange
implements BindingsRegistryListener {
    private final FastTopicMatcher fastTopicMatcher = new FastTopicMatcher();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    TopicExchange(String exchangeName, BindingDao bindingDao) {
        super(exchangeName, Exchange.Type.TOPIC, bindingDao);
        this.getBindingsRegistry().addBindingsRegistryListeners(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BindingSet getBindingsForRoute(String routingKey) {
        if (routingKey.isEmpty()) {
            return BindingSet.emptySet();
        }
        this.lock.readLock().lock();
        try {
            BindingSet matchedBindingSet = new BindingSet();
            this.fastTopicMatcher.matchingBindings(routingKey, subscribedPattern -> {
                BindingSet bindingSet = this.getBindingsRegistry().getBindingsForRoute((String)subscribedPattern);
                matchedBindingSet.add(bindingSet);
            });
            BindingSet bindingSet = matchedBindingSet;
            return bindingSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void onBind(String routingKey) {
        this.fastTopicMatcher.add(routingKey);
    }

    @Override
    public void onUnbind(String routingKey, boolean isLastSubscriber) {
        if (isLastSubscriber) {
            this.fastTopicMatcher.remove(routingKey);
        }
    }

    @Override
    public void onRetrieveAllBindingsForExchange(String routingKey) {
        this.fastTopicMatcher.add(routingKey);
    }
}

