/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.queue;

import io.ballerina.messaging.broker.core.DetachableMessage;
import io.ballerina.messaging.broker.core.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueBuffer {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueueBuffer.class);
    private final int inMemoryLimit;
    private final int indelibleMessageLimit;
    private final MessageReader messageReader;
    private AtomicInteger size = new AtomicInteger(0);
    private AtomicInteger messagesInFlight = new AtomicInteger(0);
    private AtomicInteger deliverableMessageCount = new AtomicInteger(0);
    private AtomicInteger undeliveredMessageCount = new AtomicInteger(0);
    private AtomicInteger indelibleMessageCount = new AtomicInteger(0);
    private Node firstDeliverableCandidate;
    private Node firstUndeliverable;
    private Node last;
    private Map<Long, Node> keyMap = new ConcurrentHashMap<Long, Node>();

    QueueBuffer(int inMemoryLimit, int indelibleMessageLimit, MessageReader messageReader) {
        this.inMemoryLimit = inMemoryLimit;
        this.indelibleMessageLimit = indelibleMessageLimit;
        this.messageReader = messageReader;
    }

    public synchronized void add(Message message) {
        this.linkLast(message);
        this.postProcessDeliverableNode();
    }

    public synchronized void addAllBareMessages(Collection<Message> messages) {
        for (Message message : messages) {
            this.addBareMessage(message);
        }
    }

    public synchronized void addBareMessage(Message message) {
        this.linkLast(message);
        this.postProcessBareMessage();
    }

    public synchronized boolean addIndelibleMessage(Message message) {
        int newIndelibleMessageCount = this.indelibleMessageCount.get() + 1;
        if (newIndelibleMessageCount > this.indelibleMessageLimit) {
            return false;
        }
        this.linkLast(message);
        this.postProcessIndelibleMessage();
        return true;
    }

    private void linkLast(Message newMessage) {
        Node newNode;
        this.size.incrementAndGet();
        this.undeliveredMessageCount.incrementAndGet();
        Node previousLast = this.last;
        this.last = newNode = new Node(previousLast, newMessage, null);
        this.keyMap.put(newMessage.getInternalId(), newNode);
        if (Objects.nonNull(previousLast)) {
            previousLast.next = newNode;
        }
    }

    private void postProcessDeliverableNode() {
        Node newNode = this.last;
        if (this.size.get() - this.indelibleMessageCount.get() > this.inMemoryLimit) {
            if (Objects.isNull(this.firstUndeliverable)) {
                this.firstUndeliverable = newNode;
            }
            newNode.item.clearData();
        } else {
            newNode.state.set(2);
            this.deliverableMessageCount.incrementAndGet();
            if (Objects.isNull(this.firstDeliverableCandidate)) {
                this.firstDeliverableCandidate = newNode;
            }
        }
    }

    private void postProcessBareMessage() {
        Node newNode = this.last;
        if (Objects.isNull(this.firstUndeliverable)) {
            this.firstUndeliverable = newNode;
        }
        if (Objects.isNull(this.firstDeliverableCandidate)) {
            this.firstDeliverableCandidate = newNode;
        }
    }

    private void postProcessIndelibleMessage() {
        Node newNode = this.last;
        newNode.state.set(3);
        this.indelibleMessageCount.incrementAndGet();
        if (Objects.isNull(this.firstUndeliverable)) {
            this.firstUndeliverable = newNode;
        }
        if (Objects.isNull(this.firstDeliverableCandidate)) {
            this.firstDeliverableCandidate = newNode;
        }
    }

    public synchronized void remove(long messageId) {
        Node node = this.keyMap.remove(messageId);
        if (Objects.nonNull(node)) {
            this.unlink(node);
        }
    }

    public synchronized void removeAll(Collection<DetachableMessage> messages) {
        for (DetachableMessage message : messages) {
            this.remove(message.getInternalId());
        }
    }

    private void unlink(Node node) {
        Node next = node.next;
        Node prev = node.prev;
        if (Objects.nonNull(prev)) {
            prev.next = next;
            node.prev = null;
        }
        if (next == null) {
            this.last = prev;
        } else {
            next.prev = prev;
            node.next = null;
        }
        if (node == this.firstDeliverableCandidate) {
            this.firstDeliverableCandidate = next;
        }
        if (node == this.firstUndeliverable) {
            this.firstUndeliverable = next;
        }
        node.item = null;
        this.size.decrementAndGet();
        if (node.state.get() != 3) {
            this.deliverableMessageCount.decrementAndGet();
        } else {
            this.indelibleMessageCount.decrementAndGet();
        }
        this.messagesInFlight.decrementAndGet();
        this.submitMessageReads();
    }

    public int size() {
        return this.size.get();
    }

    public int getNumberOfInflightMessages() {
        return this.messagesInFlight.get();
    }

    public int getNumberOfUndeliveredMessages() {
        return this.undeliveredMessageCount.get();
    }

    public synchronized Message getFirstDeliverable() {
        this.submitMessageReads();
        Node deliverableCandidate = this.firstDeliverableCandidate;
        if (deliverableCandidate != this.firstUndeliverable) {
            if (!deliverableCandidate.hasContent()) {
                return null;
            }
            this.firstDeliverableCandidate = deliverableCandidate.next;
            this.recordRemovingMessageForDelivery();
            return deliverableCandidate.item;
        }
        if (this.firstUndeliverable != null && this.firstUndeliverable.hasContent()) {
            Node newDeliverable = this.firstUndeliverable;
            this.firstDeliverableCandidate = this.firstUndeliverable.next;
            this.pushFirstUndeliverableCursor();
            this.recordRemovingMessageForDelivery();
            return newDeliverable.item;
        }
        return null;
    }

    private void recordRemovingMessageForDelivery() {
        this.messagesInFlight.incrementAndGet();
        this.undeliveredMessageCount.decrementAndGet();
    }

    private void pushFirstUndeliverableCursor() {
        this.firstUndeliverable = this.firstUndeliverable.next;
        while (this.firstUndeliverable != null && this.firstUndeliverable.hasContent()) {
            this.firstUndeliverable = this.firstUndeliverable.next;
        }
    }

    private void submitMessageReads() {
        Node undeliverableNode = this.firstUndeliverable;
        for (int fillableMessageCount = this.inMemoryLimit - this.deliverableMessageCount.get(); fillableMessageCount > 0 && undeliverableNode != null && undeliverableNode.state.compareAndSet(0, 1); --fillableMessageCount) {
            Message message = undeliverableNode.item;
            this.messageReader.fill(this, message);
            undeliverableNode = undeliverableNode.next;
        }
    }

    public void markMessageFilled(Message message) {
        long messageId = message.getInternalId();
        Node node = this.keyMap.get(messageId);
        if (Objects.nonNull(node)) {
            node.state.set(2);
            this.deliverableMessageCount.incrementAndGet();
        } else {
            LOGGER.warn("Could not find message {} for marking content filling", (Object)messageId);
        }
    }

    public void markMessageFillFailed(Message message) {
        long messageId = message.getInternalId();
        Node node = this.keyMap.get(messageId);
        if (Objects.nonNull(node)) {
            node.state.set(0);
        } else {
            LOGGER.warn("Could not find message {} for marking content filling failure", (Object)messageId);
        }
    }

    synchronized void addAll(List<Message> messages) {
        for (Message message : messages) {
            this.add(message);
        }
    }

    public synchronized int clear(Consumer<Message> postDeleteAction) {
        ArrayList<Node> values = new ArrayList<Node>(this.keyMap.values());
        int bufferSize = values.size();
        for (Node node : values) {
            Message message = node.item;
            message.clearData();
            this.unlink(node);
            postDeleteAction.accept(message);
        }
        return bufferSize;
    }

    @FunctionalInterface
    public static interface MessageReader {
        public void fill(QueueBuffer var1, Message var2);
    }

    private static class Node {
        private static final int BARE_MESSAGE = 0;
        private static final int SUBMITTED_FOR_FILLING = 1;
        private static final int FULL_MESSAGE = 2;
        private static final int INDELIBLE_MESSAGE = 3;
        private Message item;
        private Node next;
        private Node prev;
        private AtomicInteger state = new AtomicInteger(0);

        Node(Node prev, Message element, Node next) {
            this.item = element;
            this.next = next;
            this.prev = prev;
        }

        boolean hasContent() {
            int stateValue = this.state.get();
            return stateValue == 2 || stateValue == 3;
        }
    }
}

