/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.queue;

import io.ballerina.messaging.broker.core.configuration.BrokerCoreConfiguration;
import io.ballerina.messaging.broker.core.queue.QueueBuffer;

public class QueueBufferFactory {
    private final int indelibleMessageLimit;
    private int inMemoryCacheLimit;

    public QueueBufferFactory(BrokerCoreConfiguration configuration) {
        this.inMemoryCacheLimit = Integer.parseInt(configuration.getDurableQueueInMemoryCacheLimit());
        this.indelibleMessageLimit = Integer.parseInt(configuration.getNonDurableQueueMaxDepth());
    }

    public QueueBuffer createBuffer(QueueBuffer.MessageReader messageReader) {
        return new QueueBuffer(this.inMemoryCacheLimit, this.indelibleMessageLimit, messageReader);
    }
}

