/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.queue;

import io.ballerina.messaging.broker.core.DetachableMessage;
import io.ballerina.messaging.broker.core.Message;
import io.ballerina.messaging.broker.core.Queue;
import io.ballerina.messaging.broker.core.QueueHandler;
import javax.transaction.xa.Xid;

public class UnmodifiableQueueWrapper
extends Queue {
    private final Queue queue;

    public UnmodifiableQueueWrapper(Queue queue) {
        super(queue.getName(), queue.isDurable(), queue.isAutoDelete());
        this.queue = queue;
    }

    @Override
    public QueueHandler getQueueHandler() {
        return this.queue.getQueueHandler();
    }

    @Override
    public int capacity() {
        return this.queue.capacity();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public boolean enqueue(Message message) {
        throw new UnsupportedOperationException("Queue " + this.queue.getName() + " is unmodifiable");
    }

    @Override
    public void prepareEnqueue(Xid xid, Message message) {
        throw new UnsupportedOperationException("Queue " + this.queue.getName() + " is unmodifiable");
    }

    @Override
    public void commit(Xid xid) {
        throw new UnsupportedOperationException("Queue " + this.queue.getName() + " is unmodifiable");
    }

    @Override
    public void rollback(Xid xid) {
        throw new UnsupportedOperationException("Queue " + this.queue.getName() + " is unmodifiable");
    }

    @Override
    public Message dequeue() {
        throw new UnsupportedOperationException("Queue " + this.queue.getName() + " is unmodifiable");
    }

    @Override
    public void detach(DetachableMessage message) {
        throw new UnsupportedOperationException("Queue " + this.queue.getName() + " is unmodifiable");
    }

    @Override
    public void prepareDetach(Xid xid, DetachableMessage message) {
        throw new UnsupportedOperationException("Queue " + this.queue.getName() + " is unmodifiable");
    }

    @Override
    public int clear() {
        throw new UnsupportedOperationException("Queue " + this.queue.getName() + " is unmodifiable");
    }
}

