/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.core.rest;

import io.ballerina.messaging.broker.auth.AuthException;
import io.ballerina.messaging.broker.auth.AuthNotFoundException;
import io.ballerina.messaging.broker.auth.AuthServerException;
import io.ballerina.messaging.broker.auth.authorization.AuthorizationHandler;
import io.ballerina.messaging.broker.auth.authorization.Authorizer;
import io.ballerina.messaging.broker.auth.authorization.enums.ResourceAction;
import io.ballerina.messaging.broker.auth.authorization.enums.ResourceAuthScope;
import io.ballerina.messaging.broker.auth.authorization.enums.ResourceType;
import io.ballerina.messaging.broker.core.rest.model.ResponseMessage;
import io.ballerina.messaging.broker.core.rest.model.UserGroupList;
import java.util.Arrays;
import java.util.List;
import javax.security.auth.Subject;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;

public class AuthGrantApiDelegate {
    private final Authorizer authorizer;
    private final AuthorizationHandler authorizationHandler;

    public AuthGrantApiDelegate(Authorizer authorizer) {
        this.authorizer = authorizer;
        this.authorizationHandler = new AuthorizationHandler(authorizer);
    }

    public Response changeOwner(ResourceType resourceType, String resourceName, String owner, Subject subject) {
        try {
            this.authorizationHandler.handle(ResourceAuthScope.RESOURCE_GRANT_PERMISSION, resourceType, resourceName, ResourceAction.GRANT_PERMISSION, subject);
            boolean success = this.authorizer.changeResourceOwner(resourceType.toString(), resourceName, owner);
            if (!success) {
                throw new BadRequestException("Invalid input. Resource type: " + resourceType.toString() + ", Resource name: " + resourceName + ", Owner: " + owner);
            }
            return Response.noContent().build();
        }
        catch (AuthException e) {
            throw new NotAuthorizedException(e.getMessage(), (Object)e, new Object[0]);
        }
        catch (AuthNotFoundException e) {
            throw new NotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (AuthServerException e) {
            throw new InternalServerErrorException(e.getMessage(), (Throwable)e);
        }
    }

    public Response addUserGroupsToAction(ResourceType resourceType, String resourceName, String action, UserGroupList userGroupList, Subject subject) {
        try {
            this.authorizationHandler.handle(ResourceAuthScope.RESOURCE_GRANT_PERMISSION, resourceType, resourceName, ResourceAction.GRANT_PERMISSION, subject);
            List<String> userGroups = userGroupList.getUserGroups();
            boolean success = this.authorizer.addGroupsToResource(resourceType.toString(), resourceName, action, userGroups);
            if (!success) {
                throw new BadRequestException("Invalid input. Resource type: " + resourceType.toString() + ", Resource name: " + resourceName + ", Action name: " + action + ", User groups: " + Arrays.toString(userGroups.toArray()));
            }
            return Response.ok((Object)new ResponseMessage().message("User groups successfully added.")).build();
        }
        catch (AuthException e) {
            throw new ForbiddenException(e.getMessage(), (Throwable)e);
        }
        catch (AuthNotFoundException e) {
            throw new NotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (AuthServerException e) {
            throw new InternalServerErrorException(e.getMessage(), (Throwable)e);
        }
    }

    public Response removeUserGroup(ResourceType resourceType, String resourceName, String action, String groupName, Subject subject) {
        try {
            this.authorizationHandler.handle(ResourceAuthScope.RESOURCE_GRANT_PERMISSION, resourceType, resourceName, ResourceAction.GRANT_PERMISSION, subject);
            boolean success = this.authorizer.removeGroupFromResource(resourceType.toString(), resourceName, action, groupName);
            if (!success) {
                throw new BadRequestException("Invalid input. Resource type: " + resourceType.toString() + ", Resource name: " + resourceName + ", Action name: " + action + ", Group name: " + groupName);
            }
            return Response.ok().entity((Object)new ResponseMessage().message("User group successfully removed.")).build();
        }
        catch (AuthException e) {
            throw new ForbiddenException(e.getMessage(), (Throwable)e);
        }
        catch (AuthNotFoundException e) {
            throw new NotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (AuthServerException e) {
            throw new InternalServerErrorException(e.getMessage(), (Throwable)e);
        }
    }
}

